@extends('layouts.structure')

@section('header')
@endsection

@section('content')
<div class="container my-5">
    <div class="card shadow-lg">
        <div class="card-body">
            <h3 class="card-title mb-4 text-primary">Users</h3>
            <table class="table table-hover table-striped table-bordered" id="datatable">
                <thead class="thead-dark" >
                    <tr>
                        <th>Sr.No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($users as $index=>$user)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>{{ $user->roles->pluck('name')->join(', ') }}</td>
                        <td class="text-center">
                            <a href="{{ route('users.permissions', $user->id) }}" class="btn btn-outline-primary btn-sm">Manage Permissions</a>
                        </td>
                        {{-- <td class="text-center">
    <a href="{{ route('users.permissions', $user->id) }}" class="btn btn-outline-primary btn-sm">Manage Permissions</a>
    <form action="{{ route('users.destroy', $user->id) }}" method="POST" style="display: inline-block">
        @csrf
        @method('DELETE')
        <button type="submit" class="btn btn-outline-danger btn-sm">Delete</button>
    </form>
</td> --}}
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>

    // Initialize DataTable with export buttons
    $(document).ready(function () {
        $('#datatable').DataTable({
            dom: 'Bfrtip',
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
            responsive: true,
            autoWidth: false,
        });

    });
</script>
@endsection
