@extends('layouts.structure')

@section('header')
@endsection

@section('content')
<div class="container my-5">
    <div class="card shadow-lg border-0">
        <div class="card-header text-secondary">
            <h3 class="card-title mb-0">Manage Permissions for <span class="text-dark">{{ $user->name }}</span></h3>
        </div>
        <div class="card-body p-5">
            <form action="{{ route('users.updatePermissions', $user->id) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- Roles Section -->
                <div class="mb-5">
                    <h5 class="text-dark mb-3">Roles</h5>
                    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-3">
                        @foreach ($roles as $role)
                            <div class="col">
                                <div class="form-check form-switch form-switch-sm">
                                    <input class="form-check-input" type="checkbox" name="roles[]" value="{{ $role->name }}"
                                        {{ $user->hasRole($role->name) ? 'checked' : '' }} id="role-{{ $role->name }}">
                                    <label class="form-check-label" for="role-{{ $role->name }}">{{ $role->name }}</label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Permissions Section -->
                <div class="mb-5">
                    <h5 class="text-dark mb-3 d-flex justify-content-between align-items-center">
                        <span>Permissions</span>
                        <div>
                            <button type="button" class="btn btn-sm btn-outline-primary pill-btn me-2" id="select-all">Select All</button>
                            <button type="button" class="btn btn-sm btn-outline-danger pill-btn" id="unselect-all">Unselect All</button>
                        </div>
                    </h5>
                    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-3">
                        @foreach ($permissions as $permission)
                            <div class="col">
                                <div class="form-check form-switch form-switch-sm">
                                    <input class="form-check-input permission-checkbox" type="checkbox" name="permissions[]" value="{{ $permission->name }}"
                                        {{ $user->hasPermissionTo($permission->name) ? 'checked' : '' }} id="permission-{{ $permission->name }}">
                                    <label class="form-check-label" for="permission-{{ $permission->name }}">{{ $permission->name }}</label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="text-end">
                    <button type="submit" class="btn btn-success btn-sm">Update Permissions</button>
                    <a href="{{ route('users.index') }}"
                    class="btn btn-danger btn-sm">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    // Select All Button
    document.getElementById('select-all').addEventListener('click', function () {
        document.querySelectorAll('.permission-checkbox').forEach(function (checkbox) {
            checkbox.checked = true;
        });
    });

    // Unselect All Button
    document.getElementById('unselect-all').addEventListener('click', function () {
        document.querySelectorAll('.permission-checkbox').forEach(function (checkbox) {
            checkbox.checked = false;
        });
    });
});
</script>
@endsection
