@extends('layouts.structure')

@section('content')
    <div class="container mt-4">
        <h2>Dispatch History</h2>
        @if (session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Plan ID</th>
                    <th>User</th>
                    <th>Type</th>
                    <th>Dispatch Option</th>
                    <th>Gross Weight</th>
                    <th>Location</th>
                    <th>Remark</th>
                    <th>Packaging</th>
                    <th>Dispatched At</th>
                    <th>Notes</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($dispatches as $dispatch)
                    <tr>
                        <td>{{ $dispatch->plan_id }}</td>
                        <td>{{ $dispatch->user->name ?? 'N/A' }}</td>
                        <td>{{ $dispatch->type }}</td>
                        <td>{{ $dispatch->dispatch_option }}</td>
                        <td>{{ $dispatch->gross_weight ?? 'N/A' }}</td>
                        <td>{{ $dispatch->location ?? 'N/A' }}</td>
                        <td>{{ $dispatch->remark ?? 'N/A' }}</td>
                        <td>{{ $dispatch->packaging_type ? "{$dispatch->packaging_type} ({$dispatch->packaging_quantity})" : 'N/A' }}
                        </td>
                        <td>{{ $dispatch->dispatched_at->format('Y-m-d H:i:s') }}</td>
                        <td>{{ $dispatch->notes ?? 'N/A' }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endsection
