@extends('layouts.structure')

@section('content')
    <title>Dispatch Records</title>
    {{-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> --}}
    <style>
        .container {
            margin-top: 80px;
        }

        .table th,
        .table td {
            vertical-align: middle;
        }

        .btn-create {
            margin-bottom: 20px;
        }

        /* Simple header style */
        .table thead th {
            background-color: #f8f9fa;
            color: #212529;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 0.9rem;
        }

        /* Action buttons */
        .btn:hover {
            opacity: 0.85;
        }

        .table-responsive {
            overflow-x: auto;
        }

        @media print {

            .btn,
            .no-print {
                display: none !important;
            }
        }
    </style>

    <div class="container">
        <div class="card">
            <div class="card-header text-center">
                <h5 class="mt-2 mb-0">Dispatch Records</h5>
            </div>
            <div class="card-body">
                <!-- Success/Error Alerts -->
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <!-- Dispatch Table -->
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Sr No.</th>
                                <th>Client Name</th>
                                <th>Coil CRR No.</th>
                                <th>Gross Weight (TON)</th>
                                <th>Location</th>
                                <th>Remark</th>
                                <th>Packaging Type</th>
                                <th>Packaging Quantity</th>
                                <th>Scrap (TON)</th>
                                <th>Dispatched At</th>
                                <th>Notes</th>
                                <th class="no-print">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($dispatches as $index => $dispatch)
                                <tr>
                                    <td>{{ $dispatches->firstItem() + $index }}</td>
                                    <td>{{ $dispatch->plan->client->client_name ?? 'N/A' }}</td>
                                    <td>{{ $dispatch->plan->coil->crr_no ?? 'N/A' }}</td>
                                    <td>{{ $dispatch->gross_weight ? number_format($dispatch->gross_weight, 3) : 'N/A' }}
                                    </td>
                                    <td>{{ $dispatch->location ?? 'N/A' }}</td>
                                    <td>{{ $dispatch->remark ?? 'N/A' }}</td>
                                    <td>{{ $dispatch->packaging_type ?? 'N/A' }}</td>
                                    <td>{{ $dispatch->packaging_quantity ?? 'N/A' }}</td>
                                    <td>{{ $dispatch->scrap ? number_format($dispatch->scrap, 4) : 'N/A' }}</td>
                                    <td>{{ $dispatch->dispatched_at->format('Y-m-d H:i:s') }}</td>
                                    <td>{{ $dispatch->notes ?? 'N/A' }}</td>
                                    <td class="no-print">
                                        <a href="{{ route('dispatches.show', $dispatch->id) }}"
                                            class="btn btn-sm btn-primary btn-view">View</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="12" class="text-center">No dispatch records found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination Links -->
                <div class="mt-3">
                    {{ $dispatches->links() }}
                </div>
            </div>
        </div>
    </div>

    <!-- jQuery and Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endsection
