@extends('layouts.structure')

@section('content')
    <title>Dispatch Details</title>
    {{-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> --}}
    <style>
        .detail-label {
            font-weight: bold;
        }

        .detail-card,
        .coil-card,
        .process-card {
            margin-top: 20px;
        }

        .badge {
            padding: 5px 10px;
            border-radius: 5px;
        }

        .bg-coil {
            background-color: #17a2b8;
            color: white;
        }

        .bg-process {
            background-color: #28a745;
            color: white;
        }

        .bg-dispatch {
            background-color: #007bff;
            color: white;
        }

        .bg-scrap {
            background-color: #dc3545;
            color: white;
        }

        .table-responsive {
            overflow-x: auto;
        }

        @media print {
            .btn {
                display: none !important;
            }
        }
    </style>

    <div class="container mt-4 mb-5">
        <h2 class="text-center mb-4">Dispatch Details</h2>

        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif

        <!-- Dispatch Details -->
        <div class="card detail-card">
            <div class="card-header">
                <h4>Dispatch Information</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    {{-- <div class="col-md-6 mb-3">
                        <span class="detail-label">Plan ID:</span> {{ $dispatch->plan_id }}
                    </div> --}}
                    <div class="col-md-6 mb-3">
                        <span class="detail-label">Client Name:</span> {{ $dispatch->plan->client->client_name ?? 'N/A' }}
                    </div>
                    <div class="col-md-6 mb-3">
                        <span class="detail-label">Coil CRR No.:</span> {{ $dispatch->plan->coil->crr_no ?? 'N/A' }}
                    </div>

                    <div class="col-md-6 mb-3">
                        <span class="detail-label">Dispatch Option:</span>
                        <span
                            class="badge {{ $dispatch->dispatch_option === 'dispatch' || $dispatch->dispatch_option === 'as_is' ? 'bg-dispatch' : 'bg-scrap' }}">
                            {{ ucfirst(str_replace('_', ' ', $dispatch->dispatch_option)) }}
                        </span>
                    </div>
                    <div class="col-md-6 mb-3">
                        <span class="detail-label">Gross Weight (TON):</span>
                        {{ $dispatch->gross_weight ? number_format($dispatch->gross_weight, 3) : 'N/A' }}
                    </div>
                    <div class="col-md-6 mb-3">
                        <span class="detail-label">Location:</span> {{ $dispatch->location ?? 'N/A' }}
                    </div>
                    <div class="col-md-6 mb-3">
                        <span class="detail-label">Remark:</span> {{ $dispatch->remark ?? 'N/A' }}
                    </div>
                    <div class="col-md-6 mb-3">
                        <span class="detail-label">Packaging Type:</span> {{ $dispatch->packaging_type ?? 'N/A' }}
                    </div>
                    <div class="col-md-6 mb-3">
                        <span class="detail-label">Packaging Quantity:</span> {{ $dispatch->packaging_quantity ?? 'N/A' }}
                    </div>
                    {{-- <div class="col-md-6 mb-3">
                        <span class="detail-label">Scrap (TON):</span>
                        {{ $dispatch->scrap ? number_format($dispatch->scrap, 4) : 'N/A' }}
                    </div> --}}
                    <div class="col-md-6 mb-3">
                        <span class="detail-label">Dispatched At:</span>
                        {{ $dispatch->dispatched_at->format('Y-m-d H:i:s') }}
                    </div>
                    <div class="col-md-6 mb-3">
                        <span class="detail-label">Notes:</span> {{ $dispatch->notes ?? 'N/A' }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Coil Details -->
        <div class="card coil-card">
            <div class="card-header">
                <h4>Coil Details</h4>
            </div>
            <div class="card-body">
                @if ($dispatch->plan->coil)
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <span class="detail-label">CRR No.:</span> {{ $dispatch->plan->coil->crr_no ?? 'N/A' }}
                        </div>
                        <div class="col-md-6 mb-3">
                            <span class="detail-label">Net Weight (TON):</span>
                            {{ $dispatch->plan->coil->net_weight ? number_format($dispatch->plan->coil->net_weight, 3) : 'N/A' }}
                        </div>
                        <div class="col-md-6 mb-3">
                            <span class="detail-label">Gross Weight (TON):</span>
                            {{ $dispatch->plan->coil->gross_weight ? number_format($dispatch->plan->coil->gross_weight, 3) : 'N/A' }}
                        </div>
                        <div class="col-md-6 mb-3">
                            <span class="detail-label">Width (mm):</span>
                            {{ $dispatch->plan->coil->width ? number_format($dispatch->plan->coil->width, 2) : 'N/A' }}
                        </div>
                        <div class="col-md-6 mb-3">
                            <span class="detail-label">Thickness (mm):</span>
                            {{ $dispatch->plan->coil->thickness ? number_format($dispatch->plan->coil->thickness, 2) : 'N/A' }}
                        </div>

                       
                    </div>
                @else
                    <p>No coil details available.</p>
                @endif
            </div>
        </div>

        <!-- Process Details -->
        <div class="card process-card">
            <div class="card-header">
                <h4>Process Details</h4>
            </div>
            <div class="card-body">
                @if ($dispatch->plan->processes->isNotEmpty())
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    {{-- <th>Process ID</th> --}}
                                    <th>Process Type</th>
                                    <th>Total Cuts</th>
                                    <th>Total Weight (TON)</th>
                                    <th>Cut Details</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($dispatch->plan->processes as $process)
                                    <tr>
                                        {{-- <td>{{ $process->process_id }}</td> --}}
                                        <td>{{ strtoupper($process->process_type) }}</td>
                                        <td>
                                            {{ $process->process_type === 'crs' ? $process->crsCuts->count() : $process->ctlCuts->count() }}
                                        </td>
                                        <td>
                                            {{ $process->process_type === 'crs' ? number_format($process->crsCuts->sum('current_weight'), 3) : number_format($process->ctlCuts->sum('current_weight'), 3) }}
                                        </td>
                                        <td>
                                            @if ($process->process_type === 'crs')
                                                @if ($process->crsCuts->isNotEmpty())
                                                    <ul>
                                                        @foreach ($process->crsCuts as $cut)
                                                            <li>
                                                                Width: {{ number_format($cut->cut_width, 2) }} mm,
                                                                Weight: {{ number_format($cut->current_weight, 3) }} TON
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @else
                                                    No CRS cuts available.
                                                @endif
                                            @else
                                                @if ($process->ctlCuts->isNotEmpty())
                                                    <ul>
                                                        @foreach ($process->ctlCuts as $cut)
                                                            <li>
                                                                Width: {{ number_format($cut->cut_width, 2) }} mm,

                                                                Length: {{ number_format($cut->cut_length, 2) }} mm,
                                                                Weight: {{ number_format($cut->current_weight, 3) }} TON
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @else
                                                    No CTL cuts available.
                                                @endif
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p>No process details available.</p>
                @endif
            </div>
        </div>

        <!-- Navigation Buttons -->
        <div class="mt-3">
            <a href="{{ route('dispatches.index') }}" class="btn btn-secondary">Back to Dispatch Records</a>
            <a href="{{ route('plans.show', $dispatch->plan_id) }}" class="btn btn-primary">View Plan</a>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endsection
