{{-- @extends('layouts.structure')

@section('content')
    <title>Ready To Dispatch</title>
    <style>
        /* Existing styles remain unchanged */
        .section-title {
            background-color: #f8f9fa;
            padding: 10px;
            margin-top: 20px;
            border-left: 5px solid #0d6efd;
        }

        .coil-details {
            background-color: #e9ecef;
            padding: 15px;
            border-radius: 5px;
        }

        .process-section {
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 20px;
        }

        .badge {
            padding: 5px 10px;
            border-radius: 5px;
        }

        .bg-success {
            background-color: #28a745;
            color: white;
        }

        .bg-dark {
            background-color: #343a40;
            color: white;
        }

        .bg-info {
            background-color: #17a2b8;
            color: white;
        }

        .bg-partial {
            background-color: #ffc107;
            color: black;
        }

        .bg-dispatched {
            background-color: #6c757d;
            color: white;
        }

        .balance-weight {
            font-weight: bold;
            color: #0d6efd;
        }

        .error-message {
            color: red;
            font-size: 0.9em;
            display: none;
        }

        .warning-message {
            color: #856404;
            font-size: 0.9em;
            display: none;
            background-color: #fff3cd;
            padding: 5px;
            border-radius: 3px;
        }

        .dispatch-option {
            background-color: #f1f8ff;
            padding: 10px;
            border-radius: 5px;
            margin-top: 10px;
        }

        .dispatch-option label {
            font-weight: bold;
            margin-right: 15px;
        }

        .dispatch-option input[type="radio"] {
            margin-right: 5px;
        }

        .dispatch-fields,
        .packing-details,
        .dispatched-details {
            margin-top: 10px;
            padding: 10px;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            background-color: #fff;
        }

        .scrap-message {
            margin-top: 10px;
            padding: 10px;
            background-color: #fff3cd;
            border: 1px solid #ffeeba;
            border-radius: 5px;
            color: #856404;
        }

        .horizontal-fields {
            display: flex;
            gap: 20px;
            align-items: flex-start;
            flex-wrap: wrap;
        }

        .horizontal-fields .field-group {
            flex: 1;
            min-width: 250px;
        }

        .dimension-table {
            margin-top: 10px;
        }

        .input-error {
            border-color: red !important;
        }

        .tooltip-icon {
            margin-left: 5px;
            cursor: pointer;
            color: #0d6efd;
        }

        .disabled-section {
            background-color: #f1f1f1;
            opacity: 0.7;
            pointer-events: none;
        }

        .dispatch-details-section {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
        }

        .dispatch-details-section h5 {
            margin-bottom: 15px;
            border-bottom: 1px solid #dee2e6;
            padding-bottom: 5px;
        }

        .dimension-checkbox,
        .packing-checkbox {
            text-align: center;
        }

        .dimension-packing-checkbox {
            text-align: center;
        }

        .dimension-packing-details {
            margin-top: 10px;
            padding: 10px;
            background-color: #f9f9f9;
            border: 1px solid #e0e0e0;
            border-radius: 5px;
        }

        @media print {

            button,
            .btn,
            .btn-close {
                display: none !important;
            }

            .modal,
            .modal-backdrop {
                display: none !important;
            }

            input.form-control,
            select.form-select {
                border: none !important;
                background: transparent !important;
                padding: 0 !important;
                font-size: 1rem !important;
                line-height: normal !important;
                -webkit-appearance: none !important;
                -moz-appearance: none !important;
                appearance: none !important;
            }

            .section-title,
            .coil-details,
            .process-section,
            .dispatch-details-section {
                background-color: transparent !important;
                border: none !important;
            }

            .dimension-checkbox,
            .dimension-packing-checkbox {
                display: none !important;
            }
        }
    </style>

    <div class="container-fluid mt-4 mb-5">
        <h2 class="text-center mb-4">Ready To Dispatch</h2>

        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif

        <div class="card card-outline-info">
            <div class="card-header">
                <h4 class="card-title">Ready To Dispatch</h4>
            </div>
            <div class="card-body p-4">
                <div class="row">
                    <!-- Left Column: Form Functionality -->
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-body">
                                <form method="POST" action="{{ route('dispatch.store', $plan->id) }}" novalidate>
                                    @csrf
                                    <!-- Coil Details Section -->
                                    <div class="row mb-4 coil-details">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="client_id" class="form-label">Client Name</label>
                                                <input type="text" class="form-control" id="client_id"
                                                    value="{{ $plan->client->client_name ?? 'N/A' }}" readonly>
                                                <input type="hidden" value="{{ $plan->inward->crr_no ?? 'N/A' }}"
                                                    name="crr_no">
                                                <input type="hidden" value="{{ $plan->coil_id }}" name="coil_id">
                                                <div id="clientNameError" class="error-message">Please select a client</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="crr_no" class="form-label">CRR No.</label>
                                                <input type="text" class="form-control" id="crr_no"
                                                    value="{{ $plan->coil->crr_no ?? 'N/A' }}" readonly>
                                                <div id="crrNoError" class="error-message">Please select a CRR No.</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="grade_id" class="form-label">Grade</label>
                                                <input type="text" class="form-control" id="grade_id"
                                                    value="{{ $plan->grade->grade_name ?? 'N/A' }}" readonly>
                                                <div id="gradeError" class="error-message">Grade is required</div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="width" class="form-label">Width (mm)</label>
                                                <input type="number" class="form-control" id="width"
                                                    value="{{ $plan->coil->width ?? 0 }}" readonly>
                                                <div id="widthError" class="error-message">Width must be a positive number
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="thickness" class="form-label">Thickness (mm)</label>
                                                <input type="number" class="form-control" id="thickness"
                                                    value="{{ $plan->coil->thickness ?? 0 }}" readonly>
                                                <div id="thicknessError" class="error-message">Thickness must be a positive
                                                    number</div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="netWeight" class="form-label">Net Weight (TON)</label>
                                                <input type="number" class="form-control" id="netWeight"
                                                    value="{{ $plan->coil->net_weight ?? 0 }}" readonly>
                                                <div id="netWeightError" class="error-message">Net Weight must be a positive
                                                    number</div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Status and Dispatch Status -->
                                    <div class="row">
                                        <div class="mb-3">
                                            <div class="form-group">
                                                <strong>Status:</strong>
                                                <span class="badge bg-success">{{ $plan->status }}</span>
                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <div class="form-group">
                                                <strong>Dispatch Status:</strong>
                                                <span
                                                    class="badge {{ $plan->dispatch_status === 'Dispatched' ? 'bg-dark' : 'bg-info' }}">
                                                    {{ $plan->dispatch_status ?? 'Not Dispatched' }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Coil Balance Weight Section -->
                                    <div class="mb-3">
                                        <div class="form-group">
                                            <strong>Coil Balance Weight:</strong>
                                            <span
                                                id="coilBalanceWeight">{{ number_format(max(0, $plan->balance_weight), 3) }}</span>
                                            TON
                                            <input type="hidden" name="coil_balance_weight" id="coil_balance_weight_input"
                                                value="{{ max(0, $plan->balance_weight) }}">
                                            <input type="hidden" name="coil_scrap" id="coil_scrap_input" value="0">
                                            <div class="dispatch-option"
                                                style="display: inline-block; margin-left: 10px;">
                                                <label>Dispatch As:</label>
                                                <div>
                                                    <input type="radio" name="coil_dispatch_option" value="dispatch"
                                                        onclick="toggleCoilDispatch('dispatch')"
                                                        {{ $plan->dispatches->where('type', 'coil')->where('dispatch_option', 'scrap')->isEmpty() ? 'checked' : '' }}>
                                                    Dispatch
                                                    <input type="radio" name="coil_dispatch_option" value="scrap"
                                                        onclick="toggleCoilDispatch('scrap')"
                                                        {{ $plan->dispatches->where('type', 'coil')->where('dispatch_option', 'scrap')->isNotEmpty() ? 'checked' : '' }}>
                                                    Scrap
                                                </div>
                                            </div>
                                            <div id="coil_dispatch_fields"
                                                style="display: {{ $plan->dispatches->where('type', 'coil')->where('dispatch_option', 'scrap')->isEmpty() ? 'block' : 'none' }};"
                                                class="dispatch-fields">
                                                <div class="horizontal-fields">
                                                    <div class="field-group">
                                                        <label class="form-label" for="coil_gross_weight">Dispatch Gross
                                                            Weight (TON)</label>
                                                        <input type="number" step="0.001" class="form-control"
                                                            name="coil_gross_weight" id="coil_gross_weight">
                                                        <div class="error-message" id="coil_gross_weight-error"></div>
                                                    </div>
                                                    <div class="field-group">
                                                        <label class="form-label" for="coil_location">Dispatch
                                                            Location</label>
                                                        <input type="text" class="form-control" name="coil_location"
                                                            id="coil_location">
                                                        <div class="error-message" id="coil_location-error"></div>
                                                    </div>
                                                    <div class="field-group">
                                                        <label class="form-label" for="coil_remark">Remark</label>
                                                        <textarea class="form-control" name="coil_remark" id="coil_remark"></textarea>
                                                        <div class="error-message" id="coil_remark-error"></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="coil_scrap_message"
                                                style="display: {{ $plan->dispatches->where('type', 'coil')->where('dispatch_option', 'scrap')->isNotEmpty() ? 'block' : 'none' }};"
                                                class="scrap-message">
                                                Balance weight is added to scrap
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Scrap Details Section -->
                                    <div class="mb-3">
                                        <label class="form-label">Add Scrap:</label>
                                        <input type="radio" id="scrap_yes" name="is_scrap" value="1"
                                            onchange="toggleScrapDetails()">
                                        <label for="scrap_yes">Yes</label>
                                        <input type="radio" id="scrap_no" name="is_scrap" value="0" checked
                                            onchange="toggleScrapDetails()">
                                        <label for="scrap_no">No</label>
                                        <div id="scrap_details" class="packing-details" style="display: none;">
                                            <div class="horizontal-fields">
                                                <div class="field-group">
                                                    <label class="form-label" for="scrap_wt">Scrap Weight (TON)</label>
                                                    <input type="number" step="0.001" class="form-control"
                                                        name="scrap_wt" id="scrap_wt">
                                                    <div class="error-message" id="scrap_wt-error"></div>
                                                </div>
                                                <div class="field-group">
                                                    <label class="form-label" for="scrap_location">Scrap Location</label>
                                                    <input type="text" class="form-control" name="scrap_location"
                                                        id="scrap_location">
                                                    <div class="error-message" id="scrap_location-error"></div>
                                                </div>
                                                <div class="field-group">
                                                    <label class="form-label" for="scrap_remark">Remark</label>
                                                    <textarea class="form-control" name="scrap_remark" id="scrap_remark"></textarea>
                                                    <div class="error-message" id="scrap_remark-error"></div>
                                                </div>
                                                <div class="field-group">
                                                    <label class="form-label" for="weight_against_coil">Original Coil
                                                        Weight (TON)</label>
                                                    <input type="number" step="0.001" class="form-control"
                                                        name="weight_against_coil" id="weight_against_coil"
                                                        value="{{ $plan->coil->net_weight ?? 0 }}" readonly>
                                                    <div class="error-message" id="weight_against_coil-error"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Processes Section -->
                                    <div class="row mb-3">
                                        @foreach ($plan->processes as $index => $process)
                                            @php
                                                $totalWeight =
                                                    $process->process_type === 'crs'
                                                        ? $process->crsCuts->sum('weight')
                                                        : $process->ctlCuts->sum('weight');
                                                $currentWeight =
                                                    $process->process_type === 'crs'
                                                        ? $process->crsCuts->sum('current_weight')
                                                        : $process->ctlCuts->sum('current_weight');
                                                $dispatchedWeight = $process->dispatches->sum('gross_weight');
                                                $balanceWeight = max(
                                                    0,
                                                    $totalWeight - $currentWeight - $dispatchedWeight,
                                                );
                                                $individualWeights = [];
                                                $isDispatched =
                                                    $process->dispatches->isNotEmpty() && $balanceWeight <= 0;
                                                if ($process->process_type === 'crs') {
                                                    foreach ($process->crsCuts as $cut) {
                                                        $qty = $cut->quantity ?? 0;
                                                        $weight = $cut->weight ?? 0;
                                                        $individualWeight = $qty > 0 ? $weight / $qty : 0;
                                                        for ($i = 0; $i < $qty; $i++) {
                                                            $individualWeights[] = number_format($individualWeight, 3);
                                                        }
                                                    }
                                                }
                                            @endphp
                                            <div class="col-12 mb-3" id="process-{{ $process->process_id }}"
                                                @if ($balanceWeight === 0 && $totalWeight === 0) style="display: none;" @endif>
                                                <div
                                                    class="process-section {{ $isDispatched ? 'disabled-section' : '' }}">
                                                    <div class="card"
                                                        style="border:1px solid gray !important; width: 100%;"
                                                        data-process-index="{{ $index }}">
                                                        <div class="card-body">
                                                            <div class="form-group"
                                                                style="display:flex; align-items: center;">
                                                                <input type="checkbox" name="process_id[]"
                                                                    value="{{ $process->process_id }}" class=""
                                                                    style="margin-right:20px; height: 25px; width: 25px;"
                                                                    data-process-id="{{ $process->process_id }}"
                                                                    {{ $isDispatched ? 'disabled' : '' }}>
                                                                <strong>Process {{ $index + 1 }}
                                                                    ({{ strtoupper($process->process_type) }}
                                                                    @if ($process->process_type === 'ctl' && $process->dependent_index)
                                                                        - Dependent on Process
                                                                        {{ $process->dependent_index }}
                                                                    @endif)
                                                                </strong>
                                                                @if ($isDispatched)
                                                                    <span
                                                                        class="badge bg-dispatched ms-2">Dispatched</span>
                                                                @elseif ($process->dispatches->isNotEmpty() && $balanceWeight > 0)
                                                                    <span class="badge bg-partial ms-2">Partially
                                                                        Dispatched</span>
                                                                @endif
                                                                @if ($process->dispatches->isNotEmpty() && !$isDispatched)
                                                                    <span class="badge bg-success ms-2">Submitted</span>
                                                                @endif
                                                            </div>
                                                            <div class="form-group">
                                                                <strong>Production Line:</strong>
                                                                <span
                                                                    class="badge bg-info">{{ $process->process_type === 'crs' ? 'Line 1' : 'Line 2' }}</span>
                                                            </div>
                                                            @if (
                                                                ($process->process_type === 'crs' && $process->crsCuts->isNotEmpty()) ||
                                                                    ($process->process_type === 'ctl' && $process->ctlCuts->isNotEmpty()))
                                                                <div class="mb-3">
                                                                    <label
                                                                        class="form-label"><strong>Dimensions</strong></label>
                                                                    <table class="table table-bordered dimension-table">
                                                                        <thead>
                                                                            <tr>
                                                                                @if (!$isDispatched)
                                                                                    <th class="dimension-checkbox"></th>
                                                                                    <th class="dimension-packing-checkbox">
                                                                                        Packing</th>
                                                                                @endif
                                                                                <th>Width (mm)</th>
                                                                                <th>Length (mm)</th>
                                                                                <th>Quantity</th>
                                                                                <th>Weight (TON)</th>
                                                                                <th>Under Production Qty</th>
                                                                                <th>Current Weight (TON)</th>
                                                                                <th>Balance Weight (TON)</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            @foreach ($process->process_type === 'crs' ? $process->crsCuts : $process->ctlCuts as $cutIndex => $cut)
                                                                                <tr>
                                                                                    @if (!$isDispatched)
                                                                                        <td class="dimension-checkbox">
                                                                                            <input type="checkbox"
                                                                                                name="cuts[{{ $process->process_id }}][]"
                                                                                                value="{{ $cut->id }}"
                                                                                                class="dimension-cut-checkbox"
                                                                                                data-process-id="{{ $process->process_id }}"
                                                                                                data-cut-id="{{ $cut->id }}"
                                                                                                checked>
                                                                                        </td>
                                                                                        <td
                                                                                            class="dimension-packing-checkbox">
                                                                                            <input type="checkbox"
                                                                                                id="dimension_packing_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                class="dimension-packing-checkbox"
                                                                                                name="dimension_packing[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                value="1"
                                                                                                data-process-id="{{ $process->process_id }}"
                                                                                                data-cut-id="{{ $cut->id }}"
                                                                                                {{ $cut->od || $cut->packet_count || $cut->qty_per_packet ? 'checked' : '' }}>
                                                                                        </td>
                                                                                    @endif
                                                                                    <td>{{ number_format($cut->cut_width ?? 0, 2) }}
                                                                                    </td>
                                                                                    <td>{{ $cut->cut_length ?? 'N/A' }}
                                                                                    </td>
                                                                                    <td>{{ $cut->quantity ?? 0 }}</td>
                                                                                    <td>{{ number_format($cut->weight ?? 0, 3) }}
                                                                                    </td>
                                                                                    <td>{{ $cut->prod_qty ?? 0 }}</td>
                                                                                    <td>{{ number_format($cut->current_weight ?? 0, 3) }}
                                                                                    </td>
                                                                                    <td>{{ number_format($cut->bal_weight ?? 0, 3) }}
                                                                                    </td>
                                                                                </tr>
                                                                                @if (!$isDispatched)
                                                                                    <tr>
                                                                                        <td colspan="9"
                                                                                            style="padding: 0; border: none;">
                                                                                            <div class="dimension-packing-details"
                                                                                                id="dimension-packing-details-{{ $process->process_id }}-{{ $cut->id }}">
                                                                                                <div
                                                                                                    class="horizontal-fields">
                                                                                                    @if ($process->process_type === 'crs')
                                                                                                        <!-- CRS Packing Details for Dimension -->
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_od_{{ $process->process_id }}_{{ $cut->id }}">OD
                                                                                                                (mm)
                                                                                                            </label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control od-input"
                                                                                                                name="cut_od[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_od_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->od ?? '' }}"
                                                                                                                data-process-index="{{ $index }}"
                                                                                                                data-cut-index="{{ $cutIndex }}">
                                                                                                            <div class="error-message"
                                                                                                                id="cut_od_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_packets_{{ $process->process_id }}_{{ $cut->id }}">Packets</label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control packet-count"
                                                                                                                name="cut_packets[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_packets_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->packet_count ?? '' }}"
                                                                                                                data-process-index="{{ $index }}"
                                                                                                                data-cut-index="{{ $cutIndex }}"
                                                                                                                data-max-quantity="{{ $cut->quantity }}">
                                                                                                            <div class="error-message"
                                                                                                                id="cut_packets_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_build_up_{{ $process->process_id }}_{{ $cut->id }}">Build
                                                                                                                Up (mm)
                                                                                                                <span
                                                                                                                    class="tooltip-icon"
                                                                                                                    data-bs-toggle="tooltip"
                                                                                                                    title="Calculated as (OD - 508) / 2">?</span>
                                                                                                            </label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control buildup-input"
                                                                                                                name="cut_built_up[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_build_up_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->built_up ?? '' }}"
                                                                                                                readonly>
                                                                                                            <div class="error-message"
                                                                                                                id="cut_build_up_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_coil_qty_{{ $process->process_id }}_{{ $cut->id }}">Coil
                                                                                                                Quantity</label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control coil-qty"
                                                                                                                name="cut_coil_qty[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_coil_qty_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->coil_qty ?? $cut->quantity }}"
                                                                                                                readonly>
                                                                                                            <div class="error-message"
                                                                                                                id="cut_coil_qty_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    @else
                                                                                                        <!-- CTL Packing Details for Dimension -->
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_qty_per_packet_{{ $process->process_id }}_{{ $cut->id }}">Quantity
                                                                                                                per
                                                                                                                Packet</label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control qty-per-packet"
                                                                                                                name="cut_qty_per_packet[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_qty_per_packet_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->qty_per_packet ?? '' }}"
                                                                                                                data-process-index="{{ $index }}"
                                                                                                                data-cut-index="{{ $cutIndex }}"
                                                                                                                data-total-quantity="{{ $cut->quantity }}">
                                                                                                            <div class="error-message"
                                                                                                                id="cut_qty_per_packet_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_packets_{{ $process->process_id }}_{{ $cut->id }}">Packets</label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control packet-count"
                                                                                                                name="cut_packets[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_packets_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->packet_count ?? '' }}"
                                                                                                                data-process-index="{{ $index }}"
                                                                                                                data-cut-index="{{ $cutIndex }}"
                                                                                                                data-max-quantity="{{ $cut->quantity }}">
                                                                                                            <div class="error-message"
                                                                                                                id="cut_packets_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    @endif
                                                                                                    <div
                                                                                                        class="field-group">
                                                                                                        <label
                                                                                                            class="form-label"
                                                                                                            for="cut_packing_remark_{{ $process->process_id }}_{{ $cut->id }}">Packing
                                                                                                            Remark</label>
                                                                                                        <textarea class="form-control" name="cut_packing_remark[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                            id="cut_packing_remark_{{ $process->process_id }}_{{ $cut->id }}">{{ $cut->remark ?? '' }}</textarea>
                                                                                                        <div class="error-message"
                                                                                                            id="cut_packing_remark_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </td>
                                                                                    </tr>
                                                                                @endif
                                                                            @endforeach
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            @else
                                                                <div class="alert alert-info">
                                                                    No {{ strtoupper($process->process_type) }} cuts
                                                                    defined.
                                                                </div>
                                                            @endif
                                                            <div class="form-group">
                                                                <strong>Total Production Weight:</strong>
                                                                {{ number_format(max(0, $totalWeight), 3) }} TON
                                                            </div>
                                                            <div class="form-group">
                                                                <strong>Balance Weight:</strong>
                                                                <span
                                                                    class="balance-weight">{{ number_format($balanceWeight, 3) }}</span>
                                                                TON
                                                                <input type="hidden"
                                                                    name="balance_weight[{{ $process->process_id }}]"
                                                                    value="{{ $balanceWeight }}">
                                                                @if ($process->process_type === 'crs')
                                                                    <div class="individual-weights"
                                                                        data-process-index="{{ $index }}">
                                                                        @if (!empty($individualWeights))
                                                                            Individual Weights (TON):
                                                                            {{ implode(', ', $individualWeights) }}
                                                                        @else
                                                                            Individual Weights (TON): N/A
                                                                        @endif
                                                                    </div>
                                                                @endif
                                                            </div>
                                                            @if (!$isDispatched)
                                                                <!-- Process-Level Packing Details Section -->
                                                                <div class="packing-details"
                                                                    id="process-packing-details-{{ $process->process_id }}"
                                                                    style="display: none;">
                                                                    <strong>Process Packing Details:</strong>
                                                                    <div class="horizontal-fields">
                                                                        @if ($process->process_type === 'crs')
                                                                            <!-- CRS Packing Details for Process -->
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_od_{{ $process->process_id }}">OD
                                                                                    (mm)</label>
                                                                                <input type="number"
                                                                                    class="form-control od-input"
                                                                                    name="process_od[{{ $process->process_id }}]"
                                                                                    id="process_od_{{ $process->process_id }}"
                                                                                    value="{{ $process->od ?? '' }}"
                                                                                    data-process-index="{{ $index }}">
                                                                                <div class="error-message"
                                                                                    id="process_od_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_packets_{{ $process->process_id }}">Packets</label>
                                                                                <input type="number"
                                                                                    class="form-control packet-count"
                                                                                    name="process_packets[{{ $process->process_id }}]"
                                                                                    id="process_packets_{{ $process->process_id }}"
                                                                                    value="{{ $process->packet_count ?? '' }}"
                                                                                    data-process-index="{{ $index }}"
                                                                                    data-max-quantity="{{ $process->crsCuts->sum('quantity') }}">
                                                                                <div class="error-message"
                                                                                    id="process_packets_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_build_up_{{ $process->process_id }}">Build
                                                                                    Up (mm)
                                                                                    <span class="tooltip-icon"
                                                                                        data-bs-toggle="tooltip"
                                                                                        title="Calculated as (OD - 508) / 2">?</span>
                                                                                </label>
                                                                                <input type="number"
                                                                                    class="form-control buildup-input"
                                                                                    name="process_built_up[{{ $process->process_id }}]"
                                                                                    id="process_build_up_{{ $process->process_id }}"
                                                                                    value="{{ $process->built_up ?? '' }}"
                                                                                    readonly>
                                                                                <div class="error-message"
                                                                                    id="process_build_up_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_coil_qty_{{ $process->process_id }}">Coil
                                                                                    Quantity</label>
                                                                                <input type="number"
                                                                                    class="form-control coil-qty"
                                                                                    name="process_coil_qty[{{ $process->process_id }}]"
                                                                                    id="process_coil_qty_{{ $process->process_id }}"
                                                                                    value="{{ $process->coil_qty ?? $process->crsCuts->sum('quantity') }}"
                                                                                    readonly>
                                                                                <div class="error-message"
                                                                                    id="process_coil_qty_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                        @else
                                                                            <!-- CTL Packing Details for Process -->
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_qty_per_packet_{{ $process->process_id }}">Quantity
                                                                                    per Packet</label>
                                                                                <input type="number"
                                                                                    class="form-control qty-per-packet"
                                                                                    name="process_qty_per_packet[{{ $process->process_id }}]"
                                                                                    id="process_qty_per_packet_{{ $process->process_id }}"
                                                                                    value="{{ $process->qty_per_packet ?? '' }}"
                                                                                    data-process-index="{{ $index }}"
                                                                                    data-total-quantity="{{ $process->ctlCuts->sum('quantity') }}">
                                                                                <div class="error-message"
                                                                                    id="process_qty_per_packet_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_packets_{{ $process->process_id }}">Packets</label>
                                                                                <input type="number"
                                                                                    class="form-control packet-count"
                                                                                    name="process_packets[{{ $process->process_id }}]"
                                                                                    id="process_packets_{{ $process->process_id }}"
                                                                                    value="{{ $process->packet_count ?? '' }}"
                                                                                    data-process-index="{{ $index }}"
                                                                                    data-max-quantity="{{ $process->ctlCuts->sum('quantity') }}">
                                                                                <div class="error-message"
                                                                                    id="process_packets_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                        @endif
                                                                        <div class="field-group">
                                                                            <label class="form-label"
                                                                                for="process_packing_remark_{{ $process->process_id }}">Packing
                                                                                Remark</label>
                                                                            <textarea class="form-control" name="process_packing_remark[{{ $process->process_id }}]"
                                                                                id="process_packing_remark_{{ $process->process_id }}">{{ $process->remark ?? '' }}</textarea>
                                                                            <div class="error-message"
                                                                                id="process_packing_remark_{{ $process->process_id }}-error">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <!-- Dispatch Fields -->
                                                                <div class="dispatch-fields mt-3"
                                                                    id="dispatch-fields-{{ $process->process_id }}">
                                                                    <div class="horizontal-fields">
                                                                        <div class="field-group">
                                                                            <label class="form-label"
                                                                                for="process_gross_weight_{{ $process->process_id }}">Dispatch
                                                                                Gross Weight (TON)</label>
                                                                            <input type="number" step="0.001"
                                                                                class="form-control process-gross-weight"
                                                                                name="process_gross_weight[{{ $process->process_id }}]"
                                                                                id="process_gross_weight_{{ $process->process_id }}"
                                                                                data-process-id="{{ $process->process_id }}">
                                                                            <div class="error-message"
                                                                                id="process_gross_weight_{{ $process->process_id }}-error">
                                                                            </div>
                                                                        </div>
                                                                        <div class="field-group">
                                                                            <label class="form-label"
                                                                                for="process_location_{{ $process->process_id }}">Dispatch
                                                                                Location</label>
                                                                            <input type="text" class="form-control"
                                                                                name="process_location[{{ $process->process_id }}]"
                                                                                id="process_location_{{ $process->process_id }}">
                                                                            <div class="error-message"
                                                                                id="process_location_{{ $process->process_id }}-error">
                                                                            </div>
                                                                        </div>
                                                                        <div class="field-group">
                                                                            <label class="form-label"
                                                                                for="process_remark_{{ $process->process_id }}">Dispatch
                                                                                Remark</label>
                                                                            <textarea class="form-control" name="process_remark[{{ $process->process_id }}]"
                                                                                id="process_remark_{{ $process->process_id }}"></textarea>
                                                                            <div class="error-message"
                                                                                id="process_remark_{{ $process->process_id }}-error">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>

                                    <!-- Hidden Fields for Total Production Weight and Remaining Coil Weight -->
                                    <div class="mt-3">
                                        <input type="hidden" class="form-control" name="total_prod_wt"
                                            value="{{ max(0, $totalProdWeight) }}" id="total_prod_wt"
                                            style="max-width: 200px; display:inline;">
                                    </div>
                                    <div class="mt-3">
                                        <input type="hidden" class="form-control" name="rem_coil_wt"
                                            value="{{ max(0, $plan->balance_weight) }}" id="rem_coil_wt"
                                            style="max-width: 200px; display:inline;">
                                    </div>
                                    <div class="mt-3">
                                        <label for="notes" class="form-label">Dispatch Notes</label>
                                        <textarea class="form-control" name="notes" id="notes"></textarea>
                                    </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Right Column: Dispatch Details -->
                    <div class="col-xl-6">
                        <div class="dispatch-details-section">
                            <h5>Dispatch Details</h5>

                            <!-- Coil Dispatch Details -->
                            <div class="mb-4">
                                <h6>Coil Dispatch</h6>
                                @if ($plan->dispatches->where('type', 'coil')->isNotEmpty())
                                    @foreach ($plan->dispatches->where('type', 'coil') as $dispatch)
                                        <div class="dispatched-details">
                                            <p><strong>Type:</strong> {{ ucfirst($dispatch->type ?? 'N/A') }}</p>
                                            <p><strong>Dispatch Option:</strong>
                                                {{ ucfirst($dispatch->dispatch_option ?? 'N/A') }}</p>
                                            <p><strong>Gross Weight:</strong>
                                                {{ number_format($dispatch->gross_weight ?? 0, 3) }} TON</p>
                                            <p><strong>Location:</strong> {{ $dispatch->location ?? 'Not specified' }}</p>
                                            <p><strong>Packaging Type:</strong>
                                                {{ ucfirst($dispatch->packaging_type ?? 'N/A') }}</p>
                                            <p><strong>Packaging Quantity:</strong>
                                                {{ $dispatch->packaging_quantity ?? 'N/A' }}</p>
                                            <p><strong>Scrap:</strong> {{ number_format($dispatch->scrap ?? 0, 4) }} TON
                                            </p>
                                            <p><strong>Dispatch Remark:</strong> {{ $dispatch->remark ?? 'None' }}</p>
                                            <p><strong>Dispatch Notes:</strong> {{ $dispatch->notes ?? 'None' }}</p>
                                            <p><strong>Dispatched At:</strong>
                                                {{ $dispatch->dispatched_at ? $dispatch->dispatched_at->format('Y-m-d H:i:s') : 'N/A' }}
                                            </p>
                                            <hr>
                                        </div>
                                    @endforeach
                                @else
                                    <p>No coil dispatch records.</p>
                                @endif
                            </div>

                            <!-- Scrap Dispatch Details -->
                            <div class="mb-4">
                                <h6>Scrap Dispatch</h6>
                                @if ($plan->dispatches->where('type', 'scrap')->isNotEmpty())
                                    @foreach ($plan->dispatches->where('type', 'scrap') as $dispatch)
                                        <div class="dispatched-details">
                                            <p><strong>Type:</strong> {{ ucfirst($dispatch->type ?? 'N/A') }}</p>
                                            <p><strong>Scrap Weight:</strong>
                                                {{ number_format($dispatch->gross_weight ?? 0, 3) }} TON</p>
                                            <p><strong>Location:</strong> {{ $dispatch->location ?? 'Not specified' }}</p>
                                            <p><strong>Remark:</strong> {{ $dispatch->remark ?? 'None' }}</p>
                                            <p><strong>Dispatch Notes:</strong> {{ $dispatch->notes ?? 'None' }}</p>
                                            <p><strong>Dispatched At:</strong>
                                                {{ $dispatch->dispatched_at ? $dispatch->dispatched_at->format('Y-m-d H:i:s') : 'N/A' }}
                                            </p>
                                            <hr>
                                        </div>
                                    @endforeach
                                @else
                                    <p>No scrap dispatch records.</p>
                                @endif
                            </div>

                            <!-- Process Dispatch Details -->
                            <div class="mb-4">
                                <h6>Process Dispatch</h6>
                                @foreach ($plan->processes as $index => $process)
                                    @php
                                        $totalWeight =
                                            $process->process_type === 'crs'
                                                ? $process->crsCuts->sum('weight')
                                                : $process->ctlCuts->sum('weight');
                                        $currentWeight =
                                            $process->process_type === 'crs'
                                                ? $process->crsCuts->sum('current_weight')
                                                : $process->ctlCuts->sum('current_weight');
                                        $dispatchedWeight = $process->dispatches->sum('gross_weight');
                                        $balanceWeight = max(0, $totalWeight - $currentWeight - $dispatchedWeight);
                                    @endphp
                                    @if ($process->dispatches->isNotEmpty())
                                        <div class="dispatched-details">
                                            <h6>Process {{ $index + 1 }} ({{ strtoupper($process->process_type) }})
                                            </h6>
                                            @foreach ($process->dispatches as $dispatch)
                                                <p><strong>Type:</strong> {{ ucfirst($dispatch->type ?? 'N/A') }}</p>
                                                <p><strong>Gross Weight:</strong>
                                                    {{ number_format($dispatch->gross_weight ?? 0, 3) }} TON</p>
                                                <p><strong>Location:</strong> {{ $dispatch->location ?? 'Not specified' }}
                                                </p>
                                                <p><strong>Packaging Type:</strong>
                                                    {{ ucfirst($dispatch->packaging_type ?? 'N/A') }}</p>
                                                <p><strong>Packaging Quantity:</strong>
                                                    {{ $dispatch->packaging_quantity ?? 'N/A' }}</p>
                                                <p><strong>Scrap:</strong> {{ number_format($dispatch->scrap ?? 0, 4) }}
                                                    TON</p>
                                                <p><strong>Dispatch Remark:</strong> {{ $dispatch->remark ?? 'None' }}</p>
                                                <p><strong>Dispatch Notes:</strong> {{ $dispatch->notes ?? 'None' }}</p>
                                                <p><strong>Dispatched At:</strong>
                                                    {{ $dispatch->dispatched_at ? $dispatch->dispatched_at->format('Y-m-d H:i:s') : 'N/A' }}
                                                </p>
                                                <hr>
                                            @endforeach
                                        </div>
                                    @endif
                                @endforeach
                                @if ($plan->processes->pluck('dispatches')->flatten()->isEmpty())
                                    <p>No process dispatch records.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize tooltips
            $('[data-bs-toggle="tooltip"]').tooltip();

            // Initialize coil balance weight
            let coilBalanceWeight = {{ max(0, $plan->balance_weight) }};
            $('#coilBalanceWeight').text(coilBalanceWeight.toFixed(3));
            $('#coil_balance_weight_input').val(coilBalanceWeight.toFixed(3));

            // Check if coil was previously scrapped
            @if ($plan->dispatches->where('type', 'coil')->where('dispatch_option', 'scrap')->isNotEmpty())
                $('#coilBalanceWeight').text('0.000');
                $('#coil_balance_weight_input').val('0.000');
                $('#coil_scrap_input').val({{ $plan->balance_weight }});
            @endif

            // Hide processes with no balance weight
            @foreach ($plan->processes as $process)
                @php
                    $totalWeight = $process->process_type === 'crs' ? $process->crsCuts->sum('weight') : $process->ctlCuts->sum('weight');
                    $currentWeight = $process->process_type === 'crs' ? $process->crsCuts->sum('current_weight') : $process->ctlCuts->sum('current_weight');
                    $dispatchedWeight = $process->dispatches->sum('gross_weight');
                    $balanceWeight = max(0, $totalWeight - $currentWeight - $dispatchedWeight);
                @endphp
                @if ($balanceWeight === 0 && $totalWeight === 0)
                    $('#process-{{ $process->process_id }}').hide();
                @endif
            @endforeach

            // Update individual weights for CRS processes
            @foreach ($plan->processes as $index => $process)
                updateIndividualWeights({{ $index }});
            @endforeach

            // Initialize gross weight for each process based on checked dimensions
            @foreach ($plan->processes as $process)
                @if (!$process->dispatches->isNotEmpty() || $balanceWeight > 0)
                    updateGrossWeight({{ $process->process_id }});
                @endif
            @endforeach

            // Initialize dimension packing details visibility on page load
            $('.dimension-packing-checkbox').each(function() {
                const processId = $(this).data('process-id');
                const cutId = $(this).data('cut-id');
                toggleDimensionPackingDetails(processId, cutId);
            });

            // Initialize process packing details visibility on page load
            $('.process-checkbox').each(function() {
                const processId = $(this).data('process-id');
                toggleProcessPackingDetails(processId);
            });

            // Bind change event to dimension packing checkboxes
            $('.dimension-packing-checkbox').on('change', function() {
                const processId = $(this).data('process-id');
                const cutId = $(this).data('cut-id');
                toggleDimensionPackingDetails(processId, cutId);
            });

            // Bind change event to process checkboxes
            $('.process-checkbox').on('change', function() {
                const processId = $(this).data('process-id');
                toggleProcessPackingDetails(processId);
            });

            // Handle input changes for packing details
            $('.od-input, .packet-count, .qty-per-packet').on('input', function() {
                const $input = $(this);
                const processId = $input.attr('id').split('_')[2];
                const processIndex = $input.data('process-index');
                const processType = $input.closest('.card').find('.badge.bg-info').text().toLowerCase() ===
                    'line 1' ? 'crs' : 'ctl';
                const cutIndex = $input.data('cut-index');

                if (typeof cutIndex !== 'undefined') {
                    updateDimensionPackingDetails(processId, processIndex, processType, $input.closest(
                        '.dimension-packing-details'));
                } else {
                    updateProcessPackingDetails(processId, processIndex, processType);
                }
            });

            // Warn if packet count exceeds max quantity
            $('.packet-count').on('input', function() {
                const $input = $(this);
                const maxQuantity = parseInt($input.data('max-quantity')) || 0;
                const value = parseInt($input.val()) || 0;
                const $error = $input.siblings('.error-message');
                if (value > maxQuantity) {
                    $error.text(`Warning: Packet count exceeds maximum quantity (${maxQuantity}).`).show();
                } else {
                    $error.hide();
                }
            });

            // Update process gross weight based on selected cuts
            $('.dimension-cut-checkbox').on('change', function() {
                const processId = $(this).data('process-id');
                updateGrossWeight(processId);
            });
        });

        /**
         * Updates the gross weight for a process based on selected dimension cuts.
         * @param {number} processId - The ID of the process.
         */
        function updateGrossWeight(processId) {
            const $processGrossWeightInput = $(`#process_gross_weight_${processId}`);
            const $selectedCuts = $(`input[name="cuts[${processId}][]"]:checked`);
            let totalSelectedWeight = 0;

            $selectedCuts.each(function() {
                const $row = $(this).closest('tr');
                const weight = parseFloat($row.find('td:nth-child(6)').text()) || 0; // Weight (TON)
                totalSelectedWeight += weight;
            });

            $processGrossWeightInput.val(totalSelectedWeight.toFixed(3));
        }

        /**
         * Updates individual weights for a CRS process.
         * @param {number} processIndex - The index of the process.
         */
        function updateIndividualWeights(processIndex) {
            const $processCard = $(`.process-section .card[data-process-index="${processIndex}"]`);
            const $rows = $processCard.find('table tbody tr');
            let individualWeights = [];

            $rows.each(function() {
                const $row = $(this);
                const quantity = parseInt($row.find('td:nth-child(5)').text()) || 0;
                const totalWeight = parseFloat($row.find('td:nth-child(6)').text()) || 0;
                const individualWeight = quantity > 0 ? totalWeight / quantity : 0;
                for (let i = 0; i < quantity; i++) {
                    individualWeights.push(individualWeight.toFixed(3));
                }
            });

            const $individualWeightsSpan = $processCard.find(`.individual-weights[data-process-index="${processIndex}"]`);
            if ($individualWeightsSpan.length && individualWeights.length > 0) {
                $individualWeightsSpan.text('Individual Weights (TON): ' + individualWeights.join(', '));
            } else if ($individualWeightsSpan.length) {
                $individualWeightsSpan.text('Individual Weights (TON): N/A');
            }
        }

        /**
         * Updates packing details for a process (CRS or CTL).
         * @param {number} processId - The ID of the process.
         * @param {number} processIndex - The index of the process.
         * @param {string} processType - The type of process ('crs' or 'ctl').
         */
        function updateProcessPackingDetails(processId, processIndex, processType) {
            const $processCard = $(`.process-section .card[data-process-index="${processIndex}"]`);
            const coilID = 508;
            const thickness = {{ $plan->coil->thickness ?? 0 }};
            const materialDensity = 7.85; // Assuming steel density in g/cm³
            const grossWeight = {{ $plan->coil->net_weight ?? 0 }} * 1000; // Convert TON to kg
            const coilWidth = {{ $plan->coil->width ?? 0 }};

            if (processType === 'crs') {
                const $odInput = $(`#process_od_${processId}`);
                const $buildUpInput = $(`#process_build_up_${processId}`);
                const $packetInput = $(`#process_packets_${processId}`);
                const $coilQtyInput = $(`#process_coil_qty_${processId}`);
                const od = parseFloat($odInput.val()) || 0;
                const packetCount = parseInt($packetInput.val()) || 0;
                const maxQuantity = parseInt($packetInput.data('max-quantity')) || 0;

                // Calculate Build Up
                if (od > 0) {
                    const buildUp = ((od - coilID) / 2).toFixed(2);
                    $buildUpInput.val(buildUp);
                } else {
                    $buildUpInput.val('');
                }

                // Validate packet count
                const $packetError = $packetInput.siblings('.error-message');
                if (packetCount > maxQuantity) {
                    $packetError.text(`Warning: Packet count exceeds maximum quantity (${maxQuantity}).`).show();
                } else {
                    $packetError.hide();
                }

                // Calculate production weight
                const $rows = $processCard.find('table tbody tr');
                let productionWeight = 0;
                $rows.each(function() {
                    const $row = $(this);
                    const width = parseFloat($row.find('td:nth-child(3)').text()) || 0;
                    const quantity = parseInt($row.find('td:nth-child(5)').text()) || 0;
                    if (width && quantity) {
                        productionWeight += (grossWeight / coilWidth) * (width * quantity);
                    }
                });
                productionWeight = (productionWeight / 1000).toFixed(3); // Convert kg to TON
                $coilQtyInput.val(maxQuantity);
            } else if (processType === 'ctl') {
                const $qtyPerPacketInput = $(`#process_qty_per_packet_${processId}`);
                const $packetCountInput = $(`#process_packets_${processId}`);
                const totalQuantity = parseInt($qtyPerPacketInput.data('total-quantity')) || 0;
                const qtyPerPacket = parseInt($qtyPerPacketInput.val()) || 0;
                const packetCount = parseInt($packetCountInput.val()) || 0;
                const $error = $qtyPerPacketInput.siblings('.error-message');

                // Calculate production weight
                const $rows = $processCard.find('table tbody tr');
                let productionWeight = 0;
                $rows.each(function() {
                    const $row = $(this);
                    const width = parseFloat($row.find('td:nth-child(3)').text()) || 0;
                    const length = parseFloat($row.find('td:nth-child(4)').text()) || 0;
                    const quantity = parseInt($row.find('td:nth-child(5)').text()) || 0;
                    if (width && length && quantity) {
                        const intermediateProduct = thickness * width * length * materialDensity;
                        let productionWeightPerUnit = intermediateProduct / 1000000000; // Convert to TON
                        productionWeightPerUnit = productionWeightPerUnit.toFixed(3);
                        productionWeight += productionWeightPerUnit * quantity;
                    }
                });
                productionWeight = productionWeight.toFixed(3);

                // Calculate qty per packet
                if (packetCount > 0) {
                    const qtyPerPacketResult = Math.floor(totalQuantity / packetCount);
                    $qtyPerPacketInput.val(qtyPerPacketResult);
                }

                // Validate total quantity
                if (qtyPerPacket > 0 && packetCount > 0) {
                    const totalPacketsQty = qtyPerPacket * packetCount;
                    if (totalPacketsQty > totalQuantity) {
                        $error.text(`Warning: Total quantity (${totalPacketsQty}) exceeds maximum (${totalQuantity}).`)
                            .show();
                    } else {
                        $error.hide();
                    }
                } else {
                    $error.hide();
                }

                // Validate packet count
                const $packetError = $packetCountInput.siblings('.error-message');
                if (packetCount > totalQuantity) {
                    $packetError.text(`Warning: Packet count exceeds maximum quantity (${totalQuantity}).`).show();
                } else {
                    $packetError.hide();
                }
            }
        }

        /**
         * Updates packing details for a specific dimension.
         * @param {number} processId - The ID of the process.
         * @param {number} processIndex - The index of the process.
         * @param {string} processType - The type of process ('crs' or 'ctl').
         * @param {jQuery} $packingDetails - The jQuery object for the packing details section.
         */
        function updateDimensionPackingDetails(processId, processIndex, processType, $packingDetails) {
            const coilID = 508;
            const thickness = {{ $plan->coil->thickness ?? 0 }};
            const materialDensity = 7.85; // Assuming steel density in g/cm³
            const grossWeight = {{ $plan->coil->net_weight ?? 0 }} * 1000; // Convert TON to kg
            const coilWidth = {{ $plan->coil->width ?? 0 }};

            const cutId = $packingDetails.closest('tr').prev().find('.dimension-cut-checkbox').data('cut-id');
            const $odInput = $(`#cut_od_${processId}_${cutId}`);
            const $buildUpInput = $(`#cut_build_up_${processId}_${cutId}`);
            const $packetInput = $(`#cut_packets_${processId}_${cutId}`);
            const $coilQtyInput = $(`#cut_coil_qty_${processId}_${cutId}`);
            const $qtyPerPacketInput = $(`#cut_qty_per_packet_${processId}_${cutId}`);

            const maxQuantity = parseInt($packetInput.data('max-quantity')) || 0;
            const totalQuantity = parseInt($qtyPerPacketInput ? $qtyPerPacketInput.data('total-quantity') : 0) || 0;

            if (processType === 'crs') {
                const od = parseFloat($odInput.val()) || 0;
                const packetCount = parseInt($packetInput.val()) || 0;

                // Calculate Build Up
                if (od > 0) {
                    const buildUp = ((od - coilID) / 2).toFixed(2);
                    $buildUpInput.val(buildUp);
                } else {
                    $buildUpInput.val('');
                }

                // Validate packet count
                const $packetError = $packetInput.siblings('.error-message');
                if (packetCount > maxQuantity) {
                    $packetError.text(`Warning: Packet count exceeds maximum quantity (${maxQuantity}).`).show();
                } else {
                    $packetError.hide();
                }

                $coilQtyInput.val(maxQuantity);
            } else if (processType === 'ctl') {
                const qtyPerPacket = parseInt($qtyPerPacketInput.val()) || 0;
                const packetCount = parseInt($packetInput.val()) || 0;
                const $error = $qtyPerPacketInput.siblings('.error-message');

                // Calculate qty per packet
                if (packetCount > 0) {
                    const qtyPerPacketResult = Math.floor(totalQuantity / packetCount);
                    $qtyPerPacketInput.val(qtyPerPacketResult);
                }

                // Validate total quantity
                if (qtyPerPacket > 0 && packetCount > 0) {
                    const totalPacketsQty = qtyPerPacket * packetCount;
                    if (totalPacketsQty > totalQuantity) {
                        $error.text(`Warning: Total quantity (${totalPacketsQty}) exceeds maximum (${totalQuantity}).`)
                            .show();
                    } else {
                        $error.hide();
                    }
                } else {
                    $error.hide();
                }

                // Validate packet count
                const $packetError = $packetInput.siblings('.error-message');
                if (packetCount > totalQuantity) {
                    $packetError.text(`Warning: Packet count exceeds maximum quantity (${totalQuantity}).`).show();
                } else {
                    $packetError.hide();
                }
            }
        }

        /**
         * Toggles the visibility of coil dispatch or scrap fields based on the selected option.
         * @param {string} option - The selected option ('dispatch' or 'scrap').
         */
        function toggleCoilDispatch(option) {
            const coilDispatchFields = $('#coil_dispatch_fields');
            const coilScrapMessage = $('#coil_scrap_message');
            const coilBalanceWeightSpan = $('#coilBalanceWeight');
            const coilBalanceWeightInput = $('#coil_balance_weight_input');
            const coilScrapInput = $('#coil_scrap_input');
            const originalBalanceWeight = {{ max(0, $plan->balance_weight) }};

            if (option === 'dispatch') {
                coilDispatchFields.show();
                coilScrapMessage.hide();
                coilBalanceWeightSpan.text(originalBalanceWeight.toFixed(3));
                coilBalanceWeightInput.val(originalBalanceWeight.toFixed(3));
                coilScrapInput.val('0');
                coilDispatchFields.find('input, textarea').attr('required', true);
            } else if (option === 'scrap') {
                if (confirm('Are you sure you want to add this to scrap?')) {
                    coilDispatchFields.hide();
                    coilScrapMessage.show();
                    coilBalanceWeightSpan.text('0.000');
                    coilBalanceWeightInput.val('0.000');
                    coilScrapInput.val(originalBalanceWeight.toFixed(3));
                    coilDispatchFields.find('input, textarea').removeAttr('required');
                } else {
                    $('input[name="coil_dispatch_option"][value="dispatch"]').prop('checked', true);
                }
            }
        }

        /**
         * Toggles the visibility of scrap details based on the selected option.
         */
        function toggleScrapDetails() {
            const scrapDetails = $('#scrap_details');
            const isScrap = $('input[name="is_scrap"]:checked').val();
            scrapDetails.toggle(isScrap === '1');
            if (isScrap === '1') {
                scrapDetails.find('input:not([readonly]), textarea').attr('required', true);
            } else {
                scrapDetails.find('input, textarea').removeAttr('required');
            }
        }

        /**
         * Toggles the visibility of process-level packing details based on process checkbox.
         * @param {number} processId - The ID of the process.
         */
        function toggleProcessPackingDetails(processId) {
            const $packingDetails = $(`#process-packing-details-${processId}`);
            const $checkbox = $(`input[name="process_id[]"][value="${processId}"]`);
            const isChecked = $checkbox.is(':checked');
            $packingDetails.toggle(isChecked);
            const $packingFields = $packingDetails.find('input:not([readonly]), textarea');
            $packingFields.each(function() {
                if (isChecked) {
                    $(this).attr('required', 'required');
                } else {
                    $(this).removeAttr('required');
                }
            });
        }

        /**
         * Toggles the visibility of dimension-level packing details and manages required attributes.
         * @param {number} processId - The ID of the process.
         * @param {number} cutId - The ID of the cut.
         */
        function toggleDimensionPackingDetails(processId, cutId) {
            const $packingDetails = $(`#dimension-packing-details-${processId}-${cutId}`);
            const $checkbox = $(`#dimension_packing_${processId}_${cutId}`);
            const isChecked = $checkbox.is(':checked');

            if ($packingDetails.length) {
                $packingDetails.css('display', isChecked ? 'block' : 'none');

                const $packingFields = $packingDetails.find('input:not([readonly]), textarea');
                $packingFields.each(function() {
                    if (isChecked) {
                        $(this).attr('required', 'required');
                    } else {
                        $(this).removeAttr('required');
                        $(this).val(''); // Clear fields when hidden
                    }
                });
            } else {
                console.warn(`Packing details section for processId ${processId} and cutId ${cutId} not found.`);
            }
        }

        /**
         * Validates the form on submission.
         */
        $('form').submit(function(e) {
            let valid = true;
            const totalProdWt = $('#total_prod_wt');
            const remCoilWt = $('#rem_coil_wt');
            const coilDispatchOption = $('input[name="coil_dispatch_option"]:checked').val();
            const isScrap = $('input[name="is_scrap"]:checked').val();
            const processChecked = $('input[name="process_id[]"]:checked').length;

            // Ensure at least one action is selected
            if (!processChecked && isScrap !== '1' && (!coilDispatchOption || (coilDispatchOption === 'dispatch' &&
                    !$('#coil_gross_weight').val()))) {
                alert('Please select at least one process, enable scrap, or provide coil dispatch details.');
                e.preventDefault();
                return;
            }

            // Validate total production weight
            if ($.trim(totalProdWt.val()) === '') {
                valid = false;
                totalProdWt.addClass('input-error');
                totalProdWt.after('<div class="error-message">This field is required.</div>');
            } else {
                totalProdWt.removeClass('input-error');
                totalProdWt.siblings('.error-message').remove();
            }

            // Validate remaining coil weight
            if ($.trim(remCoilWt.val()) === '') {
                valid = false;
                remCoilWt.addClass('input-error');
                remCoilWt.after('<div class="error-message">This field is required.</div>');
            } else {
                remCoilWt.removeClass('input-error');
                remCoilWt.siblings('.error-message').remove();
            }

            // Validate coil dispatch fields
            if (coilDispatchOption === 'dispatch' && $('#coil_gross_weight').val()) {
                const $coilLocation = $('#coil_location');
                if ($.trim($coilLocation.val()) === '') {
                    valid = false;
                    $coilLocation.addClass('input-error');
                    $('#coil_location-error').text('Dispatch location is required.').show();
                } else {
                    $coilLocation.removeClass('input-error');
                    $('#coil_location-error').hide();
                }
            }

            // Validate scrap fields
            if (isScrap === '1') {
                const $scrapLocation = $('#scrap_location');
                if ($.trim($scrapLocation.val()) === '') {
                    valid = false;
                    $scrapLocation.addClass('input-error');
                    $('#scrap_location-error').text('Scrap location is required.').show();
                } else {
                    $scrapLocation.removeClass('input-error');
                    $('#scrap_location-error').hide();
                }
            }

            // Validate process dispatch fields
            $('input[name="process_id[]"]:checked').each(function() {
                const processId = $(this).val();

                // Validate that at least one cut is selected for the process
                const $selectedCuts = $(`input[name="cuts[${processId}][]"]:checked`);
                if ($selectedCuts.length === 0) {
                    valid = false;
                    alert(`Please select at least one dimension for Process ${processId}.`);
                    return false; // Break the each loop
                }

                const $locationInput = $(`#process_location_${processId}`);
                if ($.trim($locationInput.val()) === '') {
                    valid = false;
                    $locationInput.addClass('input-error');
                    $(`#process_location_${processId}-error`).text('Dispatch location is required.').show();
                } else {
                    $locationInput.removeClass('input-error');
                    $(`#process_location_${processId}-error`).hide();
                }

                const processType = $(`#process-${processId}`).find('.badge.bg-info').text()
                    .toLowerCase() === 'line 1' ? 'crs' : 'ctl';
                const $processPackingDetails = $(`#process-packing-details-${processId}`);

                // Validate process-level packing details if visible
                if ($processPackingDetails.is(':visible')) {
                    if (processType === 'crs') {
                        const $odInput = $(`#process_od_${processId}`);
                        const od = parseFloat($odInput.val()) || 0;
                        if (od <= 0) {
                            valid = false;
                            $odInput.addClass('input-error');
                            $(`#process_od_${processId}-error`).text('OD must be a positive number.')
                                .show();
                        } else {
                            $odInput.removeClass('input-error');
                            $(`#process_od_${processId}-error`).hide();
                        }

                        const $packetInput = $(`#process_packets_${processId}`);
                        const packetCount = parseInt($packetInput.val()) || 0;
                        if (packetCount <= 0) {
                            valid = false;
                            $packetInput.addClass('input-error');
                            $(`#process_packets_${processId}-error`).text(
                                'Packet count must be greater than 0.').show();
                        } else {
                            $packetInput.removeClass('input-error');
                            $(`#process_packets_${processId}-error`).hide();
                        }
                    } else if (processType === 'ctl') {
                        const $qtyPerPacketInput = $(`#process_qty_per_packet_${processId}`);
                        const qtyPerPacket = parseInt($qtyPerPacketInput.val()) || 0;
                        if (qtyPerPacket <= 0) {
                            valid = false;
                            $qtyPerPacketInput.addClass('input-error');
                            $(`#process_qty_per_packet_${processId}-error`).text(
                                'Quantity per packet must be greater than 0.').show();
                        } else {
                            $qtyPerPacketInput.removeClass('input-error');
                            $(`#process_qty_per_packet_${processId}-error`).hide();
                        }

                        const $packetInput = $(`#process_packets_${processId}`);
                        const packetCount = parseInt($packetInput.val()) || 0;
                        if (packetCount <= 0) {
                            valid = false;
                            $packetInput.addClass('input-error');
                            $(`#process_packets_${processId}-error`).text(
                                'Packet count must be greater than 0.').show();
                        } else {
                            $packetInput.removeClass('input-error');
                            $(`#process_packets_${processId}-error`).hide();
                        }

                        const totalQuantity = parseInt($qtyPerPacketInput.data('total-quantity')) || 0;
                        const totalPacketsQty = qtyPerPacket * packetCount;
                        if (totalPacketsQty > totalQuantity) {
                            valid = false;
                            $qtyPerPacketInput.addClass('input-error');
                            $(`#process_qty_per_packet_${processId}-error`).text(
                                `Total quantity (${totalPacketsQty}) exceeds maximum (${totalQuantity}).`
                            ).show();
                        }
                    }
                }

                // Validate dimension-level packing details
                $selectedCuts.each(function() {
                    const cutId = $(this).val();
                    const isDimensionPackingIncluded = $(`#dimension_packing_${processId}_${cutId}`)
                        .is(':checked');

                    if (isDimensionPackingIncluded) {
                        if (processType === 'crs') {
                            const $odInput = $(`#cut_od_${processId}_${cutId}`);
                            const od = parseFloat($odInput.val()) || 0;
                            if (od <= 0) {
                                valid = false;
                                $odInput.addClass('input-error');
                                $(`#cut_od_${processId}_${cutId}-error`).text(
                                    'OD must be a positive number.').show();
                            } else {
                                $odInput.removeClass('input-error');
                                $(`#cut_od_${processId}_${cutId}-error`).hide();
                            }

                            const $packetInput = $(`#cut_packets_${processId}_${cutId}`);
                            const packetCount = parseInt($packetInput.val()) || 0;
                            if (packetCount <= 0) {
                                valid = false;
                                $packetInput.addClass('input-error');
                                $(`#cut_packets_${processId}_${cutId}-error`).text(
                                    'Packet count must be greater than 0.').show();
                            } else {
                                $packetInput.removeClass('input-error');
                                $(`#cut_packets_${processId}_${cutId}-error`).hide();
                            }
                        } else if (processType === 'ctl') {
                            const $qtyPerPacketInput = $(
                                `#cut_qty_per_packet_${processId}_${cutId}`);
                            const qtyPerPacket = parseInt($qtyPerPacketInput.val()) || 0;
                            if (qtyPerPacket <= 0) {
                                valid = false;
                                $qtyPerPacketInput.addClass('input-error');
                                $(`#cut_qty_per_packet_${processId}_${cutId}-error`).text(
                                    'Quantity per packet must be greater than 0.').show();
                            } else {
                                $qtyPerPacketInput.removeClass('input-error');
                                $(`#cut_qty_per_packet_${processId}_${cutId}-error`).hide();
                            }

                            const $packetInput = $(`#cut_packets_${processId}_${cutId}`);
                            const packetCount = parseInt($packetInput.val()) || 0;
                            if (packetCount <= 0) {
                                valid = false;
                                $packetInput.addClass('input-error');
                                $(`#cut_packets_${processId}_${cutId}-error`).text(
                                    'Packet count must be greater than 0.').show();
                            } else {
                                $packetInput.removeClass('input-error');
                                $(`#cut_packets_${processId}_${cutId}-error`).hide();
                            }

                            const totalQuantity = parseInt($qtyPerPacketInput.data(
                                'total-quantity')) || 0;
                            const totalPacketsQty = qtyPerPacket * packetCount;
                            if (totalPacketsQty > totalQuantity) {
                                valid = false;
                                $qtyPerPacketInput.addClass('input-error');
                                $(`#cut_qty_per_packet_${processId}_${cutId}-error`).text(
                                    `Total quantity (${totalPacketsQty}) exceeds maximum (${totalQuantity}).`
                                ).show();
                            }
                        }
                    }
                });
            });

            if (!valid) {
                alert('Please fill in all required fields correctly.');
                e.preventDefault();
            }
        });
    </script>
@endsection --}}



@extends('layouts.structure')

@section('content')
    <title>Ready To Dispatch</title>
    <style>
        /* Existing styles remain unchanged */
        .section-title {
            background-color: #f8f9fa;
            padding: 10px;
            margin-top: 20px;
            border-left: 5px solid #0d6efd;
        }

        .coil-details {
            background-color: #e9ecef;
            padding: 15px;
            border-radius: 5px;
        }

        .process-section {
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 20px;
        }

        .badge {
            padding: 5px 10px;
            border-radius: 5px;
        }

        .bg-success {
            background-color: #28a745;
            color: white;
        }

        .bg-dark {
            background-color: #343a40;
            color: white;
        }

        .bg-info {
            background-color: #17a2b8;
            color: white;
        }

        .bg-partial {
            background-color: #ffc107;
            color: black;
        }

        .bg-dispatched {
            background-color: #6c757d;
            color: white;
        }

        .balance-weight {
            font-weight: bold;
            color: #0d6efd;
        }

        .error-message {
            color: red;
            font-size: 0.9em;
            display: none;
        }

        .warning-message {
            color: #856404;
            font-size: 0.9em;
            display: none;
            background-color: #fff3cd;
            padding: 5px;
            border-radius: 3px;
        }

        .dispatch-option {
            background-color: #f1f8ff;
            padding: 10px;
            border-radius: 5px;
            margin-top: 10px;
        }

        .dispatch-option label {
            font-weight: bold;
            margin-right: 15px;
        }

        .dispatch-option input[type="radio"] {
            margin-right: 5px;
        }

        .dispatch-fields,
        .packing-details,
        .dispatched-details {
            margin-top: 10px;
            padding: 10px;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            background-color: #fff;
        }

        .scrap-message {
            margin-top: 10px;
            padding: 10px;
            background-color: #fff3cd;
            border: 1px solid #ffeeba;
            border-radius: 5px;
            color: #856404;
        }

        .horizontal-fields {
            display: flex;
            gap: 20px;
            align-items: flex-start;
            flex-wrap: wrap;
        }

        .horizontal-fields .field-group {
            flex: 1;
            min-width: 250px;
        }

        .dimension-table {
            margin-top: 10px;
        }

        .input-error {
            border-color: red !important;
        }

        .tooltip-icon {
            margin-left: 5px;
            cursor: pointer;
            color: #0d6efd;
        }

        .disabled-section {
            background-color: #f1f1f1;
            opacity: 0.7;
            pointer-events: none;
        }

        .dispatch-details-section {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
        }

        .dispatch-details-section h5 {
            margin-bottom: 15px;
            border-bottom: 1px solid #dee2e6;
            padding-bottom: 5px;
        }

        .dimension-checkbox,
        .packing-checkbox {
            text-align: center;
        }

        .dimension-packing-checkbox {
            text-align: center;
        }

        .dimension-packing-details {
            margin-top: 10px;
            padding: 10px;
            background-color: #f9f9f9;
            border: 1px solid #e0e0e0;
            border-radius: 5px;
        }

        @media print {

            button,
            .btn,
            .btn-close {
                display: none !important;
            }

            .modal,
            .modal-backdrop {
                display: none !important;
            }

            input.form-control,
            select.form-select {
                border: none !important;
                background: transparent !important;
                padding: 0 !important;
                font-size: 1rem !important;
                line-height: normal !important;
                -webkit-appearance: none !important;
                -moz-appearance: none !important;
                appearance: none !important;
            }

            .section-title,
            .coil-details,
            .process-section,
            .dispatch-details-section {
                background-color: transparent !important;
                border: none !important;
            }

            .dimension-checkbox,
            .dimension-packing-checkbox {
                display: none !important;
            }
        }
    </style>

    <div class="container-fluid mt-4 mb-5">
        <h2 class="text-center mb-4">Ready To Dispatch</h2>

        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif

        <div class="card card-outline-info">
            <div class="card-header">
                <h4 class="card-title">Ready To Dispatch</h4>
            </div>
            <div class="card-body p-4">
                <div class="row">
                    <!-- Left Column: Form Functionality -->
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-body">
                                <form method="POST" action="{{ route('dispatch.store', $plan->id) }}" novalidate>
                                    @csrf
                                    <!-- Coil Details Section -->
                                    <div class="row mb-4 coil-details">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="client_id" class="form-label">Client Name</label>
                                                <input type="text" class="form-control" id="client_id"
                                                    value="{{ $plan->client->client_name ?? 'N/A' }}" readonly>
                                                <input type="hidden" value="{{ $plan->inward->crr_no ?? 'N/A' }}"
                                                    name="crr_no">
                                                <input type="hidden" value="{{ $plan->coil_id }}" name="coil_id">
                                                <div id="clientNameError" class="error-message">Please select a client</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="crr_no" class="form-label">CRR No.</label>
                                                <input type="text" class="form-control" id="crr_no"
                                                    value="{{ $plan->coil->crr_no ?? 'N/A' }}" readonly>
                                                <div id="crrNoError" class="error-message">Please select a CRR No.</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="grade_id" class="form-label">Grade</label>
                                                <input type="text" class="form-control" id="grade_id"
                                                    value="{{ $plan->grade->grade_name ?? 'N/A' }}" readonly>
                                                <div id="gradeError" class="error-message">Grade is required</div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="width" class="form-label">Width (mm)</label>
                                                <input type="number" class="form-control" id="width"
                                                    value="{{ $plan->coil->width ?? 0 }}" readonly>
                                                <div id="widthError" class="error-message">Width must be a positive number
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="thickness" class="form-label">Thickness (mm)</label>
                                                <input type="number" class="form-control" id="thickness"
                                                    value="{{ $plan->coil->thickness ?? 0 }}" readonly>
                                                <div id="thicknessError" class="error-message">Thickness must be a positive
                                                    number</div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="mb-3">
                                                <label for="netWeight" class="form-label">Net Weight (TON)</label>
                                                <input type="number" class="form-control" id="netWeight"
                                                    value="{{ $plan->coil->net_weight ?? 0 }}" readonly>
                                                <div id="netWeightError" class="error-message">Net Weight must be a positive
                                                    number</div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Status and Dispatch Status -->
                                    <div class="row">
                                        <div class="mb-3">
                                            <div class="form-group">
                                                <strong>Status:</strong>
                                                <span class="badge bg-success">{{ $plan->status }}</span>
                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <div class="form-group">
                                                <strong>Dispatch Status:</strong>
                                                <span
                                                    class="badge {{ $plan->dispatch_status === 'Dispatched' ? 'bg-dark' : 'bg-info' }}">
                                                    {{ $plan->dispatch_status ?? 'Not Dispatched' }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Coil Balance Weight Section -->
                                    <div class="mb-3">
                                        <div class="form-group">
                                            <strong>Coil Balance Weight:</strong>
                                            <span
                                                id="coilBalanceWeight">{{ number_format(max(0, $plan->balance_weight), 3) }}</span>
                                            TON
                                            <input type="hidden" name="coil_balance_weight" id="coil_balance_weight_input"
                                                value="{{ max(0, $plan->balance_weight) }}">
                                            <input type="hidden" name="coil_scrap" id="coil_scrap_input" value="0">
                                            <div class="dispatch-option"
                                                style="display: inline-block; margin-left: 10px;">
                                                <label>Dispatch As:</label>
                                                <div>
                                                    <input type="radio" name="coil_dispatch_option" value="dispatch"
                                                        onclick="toggleCoilDispatch('dispatch')"
                                                        {{ $plan->dispatches->where('type', 'coil')->where('dispatch_option', 'scrap')->isEmpty() ? 'checked' : '' }}>
                                                    Dispatch
                                                    <input type="radio" name="coil_dispatch_option" value="scrap"
                                                        onclick="toggleCoilDispatch('scrap')"
                                                        {{ $plan->dispatches->where('type', 'coil')->where('dispatch_option', 'scrap')->isNotEmpty() ? 'checked' : '' }}>
                                                    Scrap
                                                </div>
                                            </div>
                                            <div id="coil_dispatch_fields"
                                                style="display: {{ $plan->dispatches->where('type', 'coil')->where('dispatch_option', 'scrap')->isEmpty() ? 'block' : 'none' }};"
                                                class="dispatch-fields">
                                                <div class="horizontal-fields">
                                                    <div class="field-group">
                                                        <label class="form-label" for="coil_gross_weight">Dispatch Gross
                                                            Weight (TON)</label>
                                                        <input type="number" step="0.001" class="form-control"
                                                            name="coil_gross_weight" id="coil_gross_weight">
                                                        <div class="error-message" id="coil_gross_weight-error"></div>
                                                    </div>
                                                    <div class="field-group">
                                                        <label class="form-label" for="coil_location">Dispatch
                                                            Location</label>
                                                        <input type="text" class="form-control" name="coil_location"
                                                            id="coil_location">
                                                        <div class="error-message" id="coil_location-error"></div>
                                                    </div>
                                                    <div class="field-group">
                                                        <label class="form-label" for="coil_remark">Remark</label>
                                                        <textarea class="form-control" name="coil_remark" id="coil_remark"></textarea>
                                                        <div class="error-message" id="coil_remark-error"></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="coil_scrap_message"
                                                style="display: {{ $plan->dispatches->where('type', 'coil')->where('dispatch_option', 'scrap')->isNotEmpty() ? 'block' : 'none' }};"
                                                class="scrap-message">
                                                Balance weight is added to scrap
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Scrap Details Section -->
                                    <div class="mb-3">
                                        <label class="form-label">Add Scrap:</label>
                                        <input type="radio" id="scrap_yes" name="is_scrap" value="1"
                                            onchange="toggleScrapDetails()">
                                        <label for="scrap_yes">Yes</label>
                                        <input type="radio" id="scrap_no" name="is_scrap" value="0" checked
                                            onchange="toggleScrapDetails()">
                                        <label for="scrap_no">No</label>
                                        <div id="scrap_details" class="packing-details" style="display: none;">
                                            <div class="horizontal-fields">
                                                <div class="field-group">
                                                    <label class="form-label" for="scrap_wt">Scrap Weight (TON)</label>
                                                    <input type="number" step="0.001" class="form-control"
                                                        name="scrap_wt" id="scrap_wt">
                                                    <div class="error-message" id="scrap_wt-error"></div>
                                                </div>
                                                <div class="field-group">
                                                    <label class="form-label" for="scrap_location">Scrap Location</label>
                                                    <input type="text" class="form-control" name="scrap_location"
                                                        id="scrap_location">
                                                    <div class="error-message" id="scrap_location-error"></div>
                                                </div>
                                                <div class="field-group">
                                                    <label class="form-label" for="scrap_remark">Remark</label>
                                                    <textarea class="form-control" name="scrap_remark" id="scrap_remark"></textarea>
                                                    <div class="error-message" id="scrap_remark-error"></div>
                                                </div>
                                                <div class="field-group">
                                                    <label class="form-label" for="weight_against_coil">Original Coil
                                                        Weight (TON)</label>
                                                    <input type="number" step="0.001" class="form-control"
                                                        name="weight_against_coil" id="weight_against_coil"
                                                        value="{{ $plan->coil->net_weight ?? 0 }}" readonly>
                                                    <div class="error-message" id="weight_against_coil-error"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Processes Section -->
                                    <div class="row mb-3">
                                        @foreach ($plan->processes as $index => $process)
                                            @php
                                                $totalWeight =
                                                    $process->process_type === 'crs'
                                                        ? $process->crsCuts->sum('weight')
                                                        : $process->ctlCuts->sum('weight');
                                                $currentWeight =
                                                    $process->process_type === 'crs'
                                                        ? $process->crsCuts->sum('current_weight')
                                                        : $process->ctlCuts->sum('current_weight');
                                                $dispatchedWeight = $process->dispatches->sum('gross_weight');
                                                $balanceWeight = max(
                                                    0,
                                                    $totalWeight - $currentWeight - $dispatchedWeight,
                                                );
                                                $individualWeights = [];
                                                $isDispatched =
                                                    $process->dispatches->isNotEmpty() && $balanceWeight <= 0;
                                                if ($process->process_type === 'crs') {
                                                    foreach ($process->crsCuts as $cut) {
                                                        $qty = $cut->quantity ?? 0;
                                                        $weight = $cut->weight ?? 0;
                                                        $individualWeight = $qty > 0 ? $weight / $qty : 0;
                                                        for ($i = 0; $i < $qty; $i++) {
                                                            $individualWeights[] = number_format($individualWeight, 3);
                                                        }
                                                    }
                                                }
                                            @endphp
                                            <div class="col-12 mb-3" id="process-{{ $process->process_id }}"
                                                @if ($balanceWeight === 0 && $totalWeight === 0) style="display: none;" @endif>
                                                <div
                                                    class="process-section {{ $isDispatched ? 'disabled-section' : '' }}">
                                                    <div class="card"
                                                        style="border:1px solid gray !important; width: 100%;"
                                                        data-process-index="{{ $index }}">
                                                        <div class="card-body">
                                                            <div class="form-group"
                                                                style="display:flex; align-items: center;">
                                                                <input type="checkbox" name="process_id[]"
                                                                    value="{{ $process->process_id }}" class=""
                                                                    style="margin-right:20px; height: 25px; width: 25px;"
                                                                    data-process-id="{{ $process->process_id }}"
                                                                    {{ $isDispatched ? 'disabled' : '' }}>
                                                                <strong>Process {{ $index + 1 }}
                                                                    ({{ strtoupper($process->process_type) }}
                                                                    @if ($process->process_type === 'ctl' && $process->dependent_index)
                                                                        - Dependent on Process
                                                                        {{ $process->dependent_index }}
                                                                    @endif)
                                                                </strong>
                                                                @if ($isDispatched)
                                                                    <span
                                                                        class="badge bg-dispatched ms-2">Dispatched</span>
                                                                @elseif ($process->dispatches->isNotEmpty() && $balanceWeight > 0)
                                                                    <span class="badge bg-partial ms-2">Partially
                                                                        Dispatched</span>
                                                                @endif
                                                                @if ($process->dispatches->isNotEmpty() && !$isDispatched)
                                                                    <span class="badge bg-success ms-2">Submitted</span>
                                                                @endif
                                                            </div>
                                                            <div class="form-group">
                                                                <strong>Production Line:</strong>
                                                                <span
                                                                    class="badge bg-info">{{ $process->process_type === 'crs' ? 'Line 1' : 'Line 2' }}</span>
                                                            </div>
                                                            @if (
                                                                ($process->process_type === 'crs' && $process->crsCuts->isNotEmpty()) ||
                                                                    ($process->process_type === 'ctl' && $process->ctlCuts->isNotEmpty()))
                                                                <div class="mb-3">
                                                                    <label
                                                                        class="form-label"><strong>Dimensions</strong></label>
                                                                    <table class="table table-bordered dimension-table">
                                                                        <thead>
                                                                            <tr>
                                                                                @if (!$isDispatched)
                                                                                    <th class="dimension-checkbox"></th>
                                                                                    <th class="dimension-packing-checkbox">
                                                                                        Packing</th>
                                                                                @endif
                                                                                <th>Width (mm)</th>
                                                                                <th>Length (mm)</th>
                                                                                <th>Quantity</th>
                                                                                <th>Weight (TON)</th>
                                                                                <th>Under Production Qty</th>
                                                                                <th>Current Weight (TON)</th>
                                                                                <th>Balance Weight (TON)</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            @foreach ($process->process_type === 'crs' ? $process->crsCuts : $process->ctlCuts as $cutIndex => $cut)
                                                                                <tr>
                                                                                    @if (!$isDispatched)
                                                                                        <td class="dimension-checkbox">
                                                                                            <input type="checkbox"
                                                                                                name="cuts[{{ $process->process_id }}][]"
                                                                                                value="{{ $cut->id }}"
                                                                                                class="dimension-cut-checkbox"
                                                                                                data-process-id="{{ $process->process_id }}"
                                                                                                data-cut-id="{{ $cut->id }}"
                                                                                                checked>
                                                                                        </td>
                                                                                        <td
                                                                                            class="dimension-packing-checkbox">
                                                                                            <input type="checkbox"
                                                                                                id="dimension_packing_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                class="dimension-packing-checkbox"
                                                                                                name="dimension_packing[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                value="1"
                                                                                                data-process-id="{{ $process->process_id }}"
                                                                                                data-cut-id="{{ $cut->id }}"
                                                                                                {{ $cut->od || $cut->packet_count || $cut->qty_per_packet ? 'checked' : '' }}>
                                                                                        </td>
                                                                                    @endif
                                                                                    <td>{{ number_format($cut->cut_width ?? 0, 2) }}
                                                                                    </td>
                                                                                    <td>{{ $cut->cut_length ?? 'N/A' }}
                                                                                    </td>
                                                                                    <td>{{ $cut->quantity ?? 0 }}</td>
                                                                                    <td>{{ number_format($cut->weight ?? 0, 3) }}
                                                                                    </td>
                                                                                    <td>{{ $cut->prod_qty ?? 0 }}</td>
                                                                                    <td>{{ number_format($cut->current_weight ?? 0, 3) }}
                                                                                    </td>
                                                                                    <td>{{ number_format($cut->bal_weight ?? 0, 3) }}
                                                                                    </td>
                                                                                </tr>
                                                                                @if (!$isDispatched)
                                                                                    <tr>
                                                                                        <td colspan="9"
                                                                                            style="padding: 0; border: none;">
                                                                                            <div class="dimension-packing-details"
                                                                                                id="dimension-packing-details-{{ $process->process_id }}-{{ $cut->id }}">
                                                                                                <div
                                                                                                    class="horizontal-fields">
                                                                                                    @if ($process->process_type === 'crs')
                                                                                                        <!-- CRS Packing Details for Dimension -->
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_od_{{ $process->process_id }}_{{ $cut->id }}">OD
                                                                                                                (mm)
                                                                                                            </label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control od-input"
                                                                                                                name="cut_od[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_od_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->od ?? '' }}"
                                                                                                                data-process-index="{{ $index }}"
                                                                                                                data-cut-index="{{ $cutIndex }}">
                                                                                                            <div class="error-message"
                                                                                                                id="cut_od_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_packets_{{ $process->process_id }}_{{ $cut->id }}">Packets</label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control packet-count"
                                                                                                                name="cut_packets[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_packets_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->packet_count ?? '' }}"
                                                                                                                data-process-index="{{ $index }}"
                                                                                                                data-cut-index="{{ $cutIndex }}"
                                                                                                                data-max-quantity="{{ $cut->quantity }}">
                                                                                                            <div class="error-message"
                                                                                                                id="cut_packets_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_build_up_{{ $process->process_id }}_{{ $cut->id }}">Build
                                                                                                                Up (mm)
                                                                                                                <span
                                                                                                                    class="tooltip-icon"
                                                                                                                    data-bs-toggle="tooltip"
                                                                                                                    title="Calculated as (OD - 508) / 2">?</span>
                                                                                                            </label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control buildup-input"
                                                                                                                name="cut_built_up[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_build_up_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->built_up ?? '' }}"
                                                                                                                readonly>
                                                                                                            <div class="error-message"
                                                                                                                id="cut_build_up_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_coil_qty_{{ $process->process_id }}_{{ $cut->id }}">Coil
                                                                                                                Quantity</label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control coil-qty"
                                                                                                                name="cut_coil_qty[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_coil_qty_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->coil_qty ?? $cut->quantity }}"
                                                                                                                readonly>
                                                                                                            <div class="error-message"
                                                                                                                id="cut_coil_qty_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    @else
                                                                                                        <!-- CTL Packing Details for Dimension -->
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_qty_per_packet_{{ $process->process_id }}_{{ $cut->id }}">Quantity
                                                                                                                per
                                                                                                                Packet</label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control qty-per-packet"
                                                                                                                name="cut_qty_per_packet[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_qty_per_packet_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->qty_per_packet ?? '' }}"
                                                                                                                data-process-index="{{ $index }}"
                                                                                                                data-cut-index="{{ $cutIndex }}"
                                                                                                                data-total-quantity="{{ $cut->quantity }}">
                                                                                                            <div class="error-message"
                                                                                                                id="cut_qty_per_packet_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                        <div
                                                                                                            class="field-group">
                                                                                                            <label
                                                                                                                class="form-label"
                                                                                                                for="cut_packets_{{ $process->process_id }}_{{ $cut->id }}">Packets</label>
                                                                                                            <input
                                                                                                                type="number"
                                                                                                                class="form-control packet-count"
                                                                                                                name="cut_packets[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                                id="cut_packets_{{ $process->process_id }}_{{ $cut->id }}"
                                                                                                                value="{{ $cut->packet_count ?? '' }}"
                                                                                                                data-process-index="{{ $index }}"
                                                                                                                data-cut-index="{{ $cutIndex }}"
                                                                                                                data-max-quantity="{{ $cut->quantity }}">
                                                                                                            <div class="error-message"
                                                                                                                id="cut_packets_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    @endif
                                                                                                    <div
                                                                                                        class="field-group">
                                                                                                        <label
                                                                                                            class="form-label"
                                                                                                            for="cut_packing_remark_{{ $process->process_id }}_{{ $cut->id }}">Packing
                                                                                                            Remark</label>
                                                                                                        <textarea class="form-control" name="cut_packing_remark[{{ $process->process_id }}][{{ $cut->id }}]"
                                                                                                            id="cut_packing_remark_{{ $process->process_id }}_{{ $cut->id }}">{{ $cut->remark ?? '' }}</textarea>
                                                                                                        <div class="error-message"
                                                                                                            id="cut_packing_remark_{{ $process->process_id }}_{{ $cut->id }}-error">
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </td>
                                                                                    </tr>
                                                                                @endif
                                                                            @endforeach
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            @else
                                                                <div class="alert alert-info">
                                                                    No {{ strtoupper($process->process_type) }} cuts
                                                                    defined.
                                                                </div>
                                                            @endif
                                                            <div class="form-group">
                                                                <strong>Total Production Weight:</strong>
                                                                {{ number_format(max(0, $totalWeight), 3) }} TON
                                                            </div>
                                                            <div class="form-group">
                                                                <strong>Balance Weight:</strong>
                                                                <span
                                                                    class="balance-weight">{{ number_format($balanceWeight, 3) }}</span>
                                                                TON
                                                                <input type="hidden"
                                                                    name="balance_weight[{{ $process->process_id }}]"
                                                                    value="{{ $balanceWeight }}">
                                                                @if ($process->process_type === 'crs')
                                                                    <div class="individual-weights"
                                                                        data-process-index="{{ $index }}">
                                                                        @if (!empty($individualWeights))
                                                                            Individual Weights (TON):
                                                                            {{ implode(', ', $individualWeights) }}
                                                                        @else
                                                                            Individual Weights (TON): N/A
                                                                        @endif
                                                                    </div>
                                                                @endif
                                                            </div>
                                                            @if (!$isDispatched)
                                                                <!-- Process-Level Packing Details Section -->
                                                                <div class="packing-details"
                                                                    id="process-packing-details-{{ $process->process_id }}"
                                                                    style="display: none;">
                                                                    <strong>Process Packing Details:</strong>
                                                                    <div class="horizontal-fields">
                                                                        @if ($process->process_type === 'crs')
                                                                            <!-- CRS Packing Details for Process -->
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_od_{{ $process->process_id }}">OD
                                                                                    (mm)</label>
                                                                                <input type="number"
                                                                                    class="form-control od-input"
                                                                                    name="process_od[{{ $process->process_id }}]"
                                                                                    id="process_od_{{ $process->process_id }}"
                                                                                    value="{{ $process->od ?? '' }}"
                                                                                    data-process-index="{{ $index }}">
                                                                                <div class="error-message"
                                                                                    id="process_od_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_packets_{{ $process->process_id }}">Packets</label>
                                                                                <input type="number"
                                                                                    class="form-control packet-count"
                                                                                    name="process_packets[{{ $process->process_id }}]"
                                                                                    id="process_packets_{{ $process->process_id }}"
                                                                                    value="{{ $process->packet_count ?? '' }}"
                                                                                    data-process-index="{{ $index }}"
                                                                                    data-max-quantity="{{ $process->crsCuts->sum('quantity') }}">
                                                                                <div class="error-message"
                                                                                    id="process_packets_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_build_up_{{ $process->process_id }}">Build
                                                                                    Up (mm)
                                                                                    <span class="tooltip-icon"
                                                                                        data-bs-toggle="tooltip"
                                                                                        title="Calculated as (OD - 508) / 2">?</span>
                                                                                </label>
                                                                                <input type="number"
                                                                                    class="form-control buildup-input"
                                                                                    name="process_built_up[{{ $process->process_id }}]"
                                                                                    id="process_build_up_{{ $process->process_id }}"
                                                                                    value="{{ $process->built_up ?? '' }}"
                                                                                    readonly>
                                                                                <div class="error-message"
                                                                                    id="process_build_up_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_coil_qty_{{ $process->process_id }}">Coil
                                                                                    Quantity</label>
                                                                                <input type="number"
                                                                                    class="form-control coil-qty"
                                                                                    name="process_coil_qty[{{ $process->process_id }}]"
                                                                                    id="process_coil_qty_{{ $process->process_id }}"
                                                                                    value="{{ $process->coil_qty ?? $process->crsCuts->sum('quantity') }}"
                                                                                    readonly>
                                                                                <div class="error-message"
                                                                                    id="process_coil_qty_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                        @else
                                                                            <!-- CTL Packing Details for Process -->
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_qty_per_packet_{{ $process->process_id }}">Quantity
                                                                                    per Packet</label>
                                                                                <input type="number"
                                                                                    class="form-control qty-per-packet"
                                                                                    name="process_qty_per_packet[{{ $process->process_id }}]"
                                                                                    id="process_qty_per_packet_{{ $process->process_id }}"
                                                                                    value="{{ $process->qty_per_packet ?? '' }}"
                                                                                    data-process-index="{{ $index }}"
                                                                                    data-total-quantity="{{ $process->ctlCuts->sum('quantity') }}">
                                                                                <div class="error-message"
                                                                                    id="process_qty_per_packet_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                            <div class="field-group">
                                                                                <label class="form-label"
                                                                                    for="process_packets_{{ $process->process_id }}">Packets</label>
                                                                                <input type="number"
                                                                                    class="form-control packet-count"
                                                                                    name="process_packets[{{ $process->process_id }}]"
                                                                                    id="process_packets_{{ $process->process_id }}"
                                                                                    value="{{ $process->packet_count ?? '' }}"
                                                                                    data-process-index="{{ $index }}"
                                                                                    data-max-quantity="{{ $process->ctlCuts->sum('quantity') }}">
                                                                                <div class="error-message"
                                                                                    id="process_packets_{{ $process->process_id }}-error">
                                                                                </div>
                                                                            </div>
                                                                        @endif
                                                                        <div class="field-group">
                                                                            <label class="form-label"
                                                                                for="process_packing_remark_{{ $process->process_id }}">Packing
                                                                                Remark</label>
                                                                            <textarea class="form-control" name="process_packing_remark[{{ $process->process_id }}]"
                                                                                id="process_packing_remark_{{ $process->process_id }}">{{ $process->remark ?? '' }}</textarea>
                                                                            <div class="error-message"
                                                                                id="process_packing_remark_{{ $process->process_id }}-error">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <!-- Dispatch Fields -->
                                                                <div class="dispatch-fields mt-3"
                                                                    id="dispatch-fields-{{ $process->process_id }}">
                                                                    <div class="horizontal-fields">
                                                                        <div class="field-group">
                                                                            <label class="form-label"
                                                                                for="process_gross_weight_{{ $process->process_id }}">Dispatch
                                                                                Gross Weight (TON)</label>
                                                                            <input type="number" step="0.001"
                                                                                class="form-control process-gross-weight"
                                                                                name="process_gross_weight[{{ $process->process_id }}]"
                                                                                id="process_gross_weight_{{ $process->process_id }}"
                                                                                data-process-id="{{ $process->process_id }}">
                                                                            <div class="error-message"
                                                                                id="process_gross_weight_{{ $process->process_id }}-error">
                                                                            </div>
                                                                        </div>
                                                                        <div class="field-group">
                                                                            <label class="form-label"
                                                                                for="process_location_{{ $process->process_id }}">Dispatch
                                                                                Location</label>
                                                                            <input type="text" class="form-control"
                                                                                name="process_location[{{ $process->process_id }}]"
                                                                                id="process_location_{{ $process->process_id }}">
                                                                            <div class="error-message"
                                                                                id="process_location_{{ $process->process_id }}-error">
                                                                            </div>
                                                                        </div>
                                                                        <div class="field-group">
                                                                            <label class="form-label"
                                                                                for="process_remark_{{ $process->process_id }}">Dispatch
                                                                                Remark</label>
                                                                            <textarea class="form-control" name="process_remark[{{ $process->process_id }}]"
                                                                                id="process_remark_{{ $process->process_id }}"></textarea>
                                                                            <div class="error-message"
                                                                                id="process_remark_{{ $process->process_id }}-error">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>

                                    <!-- Hidden Fields for Total Production Weight and Remaining Coil Weight -->
                                    <div class="mt-3">
                                        <input type="hidden" class="form-control" name="total_prod_wt"
                                            value="{{ max(0, $totalProdWeight) }}" id="total_prod_wt"
                                            style="max-width: 200px; display:inline;">
                                    </div>
                                    <div class="mt-3">
                                        <input type="hidden" class="form-control" name="rem_coil_wt"
                                            value="{{ max(0, $plan->balance_weight) }}" id="rem_coil_wt"
                                            style="max-width: 200px; display:inline;">
                                    </div>
                                    <div class="mt-3">
                                        <label for="notes" class="form-label">Dispatch Notes</label>
                                        <textarea class="form-control" name="notes" id="notes"></textarea>
                                    </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Right Column: Dispatch Details -->
                    <div class="col-xl-6">
                        <div class="dispatch-details-section">
                            <h5>Dispatch Details</h5>

                            <!-- Coil Dispatch Details -->
                            <div class="mb-4">
                                <h6>Coil Dispatch</h6>
                                @if ($plan->dispatches->where('type', 'coil')->isNotEmpty())
                                    @foreach ($plan->dispatches->where('type', 'coil') as $dispatch)
                                        <div class="dispatched-details">
                                            <p><strong>Type:</strong> {{ ucfirst($dispatch->type ?? 'N/A') }}</p>
                                            <p><strong>Dispatch Option:</strong>
                                                {{ ucfirst($dispatch->dispatch_option ?? 'N/A') }}</p>
                                            <p><strong>Gross Weight:</strong>
                                                {{ number_format($dispatch->gross_weight ?? 0, 3) }} TON</p>
                                            <p><strong>Location:</strong> {{ $dispatch->location ?? 'Not specified' }}</p>
                                            <p><strong>Packaging Type:</strong>
                                                {{ ucfirst($dispatch->packaging_type ?? 'N/A') }}</p>
                                            <p><strong>Packaging Quantity:</strong>
                                                {{ $dispatch->packaging_quantity ?? 'N/A' }}</p>
                                            <p><strong>Scrap:</strong> {{ number_format($dispatch->scrap ?? 0, 4) }} TON
                                            </p>
                                            <p><strong>Dispatch Remark:</strong> {{ $dispatch->remark ?? 'None' }}</p>
                                            <p><strong>Dispatch Notes:</strong> {{ $dispatch->notes ?? 'None' }}</p>
                                            <p><strong>Dispatched At:</strong>
                                                {{ $dispatch->dispatched_at ? $dispatch->dispatched_at->format('Y-m-d H:i:s') : 'N/A' }}
                                            </p>
                                            <hr>
                                        </div>
                                    @endforeach
                                @else
                                    <p>No coil dispatch records.</p>
                                @endif
                            </div>

                            <!-- Scrap Dispatch Details -->
                            <div class="mb-4">
                                <h6>Scrap Dispatch</h6>
                                @if ($plan->dispatches->where('type', 'scrap')->isNotEmpty())
                                    @foreach ($plan->dispatches->where('type', 'scrap') as $dispatch)
                                        <div class="dispatched-details">
                                            <p><strong>Type:</strong> {{ ucfirst($dispatch->type ?? 'N/A') }}</p>
                                            <p><strong>Scrap Weight:</strong>
                                                {{ number_format($dispatch->gross_weight ?? 0, 3) }} TON</p>
                                            <p><strong>Location:</strong> {{ $dispatch->location ?? 'Not specified' }}</p>
                                            <p><strong>Remark:</strong> {{ $dispatch->remark ?? 'None' }}</p>
                                            <p><strong>Dispatch Notes:</strong> {{ $dispatch->notes ?? 'None' }}</p>
                                            <p><strong>Dispatched At:</strong>
                                                {{ $dispatch->dispatched_at ? $dispatch->dispatched_at->format('Y-m-d H:i:s') : 'N/A' }}
                                            </p>
                                            <hr>
                                        </div>
                                    @endforeach
                                @else
                                    <p>No scrap dispatch records.</p>
                                @endif
                            </div>

                            <!-- Process Dispatch Details -->
                            <div class="mb-4">
                                <h6>Process Dispatch</h6>
                                @foreach ($plan->processes as $index => $process)
                                    @php
                                        $totalWeight =
                                            $process->process_type === 'crs'
                                                ? $process->crsCuts->sum('weight')
                                                : $process->ctlCuts->sum('weight');
                                        $currentWeight =
                                            $process->process_type === 'crs'
                                                ? $process->crsCuts->sum('current_weight')
                                                : $process->ctlCuts->sum('current_weight');
                                        $dispatchedWeight = $process->dispatches->sum('gross_weight');
                                        $balanceWeight = max(0, $totalWeight - $currentWeight - $dispatchedWeight);
                                    @endphp
                                    @if ($process->dispatches->isNotEmpty())
                                        <div class="dispatched-details">
                                            <h6>Process {{ $index + 1 }} ({{ strtoupper($process->process_type) }})
                                            </h6>
                                            @foreach ($process->dispatches as $dispatch)
                                                <p><strong>Type:</strong> {{ ucfirst($dispatch->type ?? 'N/A') }}</p>
                                                <p><strong>Gross Weight:</strong>
                                                    {{ number_format($dispatch->gross_weight ?? 0, 3) }} TON</p>
                                                <p><strong>Location:</strong> {{ $dispatch->location ?? 'Not specified' }}
                                                </p>
                                                <p><strong>Packaging Type:</strong>
                                                    {{ ucfirst($dispatch->packaging_type ?? 'N/A') }}</p>
                                                <p><strong>Packaging Quantity:</strong>
                                                    {{ $dispatch->packaging_quantity ?? 'N/A' }}</p>
                                                <p><strong>Scrap:</strong> {{ number_format($dispatch->scrap ?? 0, 4) }}
                                                    TON</p>
                                                <p><strong>Dispatch Remark:</strong> {{ $dispatch->remark ?? 'None' }}</p>
                                                <p><strong>Dispatch Notes:</strong> {{ $dispatch->notes ?? 'None' }}</p>
                                                <p><strong>Dispatched At:</strong>
                                                    {{ $dispatch->dispatched_at ? $dispatch->dispatched_at->format('Y-m-d H:i:s') : 'N/A' }}
                                                </p>
                                                <hr>
                                            @endforeach
                                        </div>
                                    @endif
                                @endforeach
                                @if ($plan->processes->pluck('dispatches')->flatten()->isEmpty())
                                    <p>No process dispatch records.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize tooltips
            $('[data-bs-toggle="tooltip"]').tooltip();

            // Initialize coil balance weight
            let coilBalanceWeight = {{ max(0, $plan->balance_weight) }};
            $('#coilBalanceWeight').text(coilBalanceWeight.toFixed(3));
            $('#coil_balance_weight_input').val(coilBalanceWeight.toFixed(3));

            // Check if coil was previously scrapped
            @if ($plan->dispatches->where('type', 'coil')->where('dispatch_option', 'scrap')->isNotEmpty())
                $('#coilBalanceWeight').text('0.000');
                $('#coil_balance_weight_input').val('0.000');
                $('#coil_scrap_input').val({{ $plan->balance_weight }});
            @endif

            // Hide processes with no balance weight
            @foreach ($plan->processes as $process)
                @php
                    $totalWeight = $process->process_type === 'crs' ? $process->crsCuts->sum('weight') : $process->ctlCuts->sum('weight');
                    $currentWeight = $process->process_type === 'crs' ? $process->crsCuts->sum('current_weight') : $process->ctlCuts->sum('current_weight');
                    $dispatchedWeight = $process->dispatches->sum('gross_weight');
                    $balanceWeight = max(0, $totalWeight - $currentWeight - $dispatchedWeight);
                @endphp
                @if ($balanceWeight === 0 && $totalWeight === 0)
                    $('#process-{{ $process->process_id }}').hide();
                @endif
            @endforeach

            // Update individual weights for CRS processes
            @foreach ($plan->processes as $index => $process)
                updateIndividualWeights({{ $index }});
            @endforeach

            // Initialize gross weight for each process based on checked dimensions
            @foreach ($plan->processes as $process)
                @if (!$process->dispatches->isNotEmpty() || $balanceWeight > 0)
                    updateGrossWeight({{ $process->process_id }});
                @endif
            @endforeach

            // Initialize dimension packing details visibility on page load
            $('.dimension-packing-checkbox').each(function() {
                const processId = $(this).data('process-id');
                const cutId = $(this).data('cut-id');
                toggleDimensionPackingDetails(processId, cutId);
            });

            // Initialize process packing details visibility on page load
            $('.process-checkbox').each(function() {
                const processId = $(this).data('process-id');
                toggleProcessPackingDetails(processId);
            });

            // Bind change event to dimension packing checkboxes
            $('.dimension-packing-checkbox').on('change', function() {
                const processId = $(this).data('process-id');
                const cutId = $(this).data('cut-id');
                toggleDimensionPackingDetails(processId, cutId);
            });

            // Bind change event to process checkboxes
            $('.process-checkbox').on('change', function() {
                const processId = $(this).data('process-id');
                toggleProcessPackingDetails(processId);
            });

            // Handle input changes for packing details
            $('.od-input, .packet-count, .qty-per-packet').on('input', function() {
                const $input = $(this);
                const processId = $input.attr('id').split('_')[2];
                const processIndex = $input.data('process-index');
                const processType = $input.closest('.card').find('.badge.bg-info').text().toLowerCase() ===
                    'line 1' ? 'crs' : 'ctl';
                const cutIndex = $input.data('cut-index');

                if (typeof cutIndex !== 'undefined') {
                    updateDimensionPackingDetails(processId, processIndex, processType, $input.closest(
                        '.dimension-packing-details'));
                } else {
                    updateProcessPackingDetails(processId, processIndex, processType);
                }
            });

            // Warn if packet count exceeds max quantity
            $('.packet-count').on('input', function() {
                const $input = $(this);
                const maxQuantity = parseInt($input.data('max-quantity')) || 0;
                const value = parseInt($input.val()) || 0;
                const $error = $input.siblings('.error-message');
                if (value > maxQuantity) {
                    $error.text(`Warning: Packet count exceeds maximum quantity (${maxQuantity}).`).show();
                } else {
                    $error.hide();
                }
            });

            // Update process gross weight based on selected cuts
            $('.dimension-cut-checkbox').on('change', function() {
                const processId = $(this).data('process-id');
                updateGrossWeight(processId);
            });
        });

        /**
         * Updates the gross weight for a process based on selected dimension cuts.
         * @param {number} processId - The ID of the process.
         */
        function updateGrossWeight(processId) {
            const $processGrossWeightInput = $(`#process_gross_weight_${processId}`);
            const $selectedCuts = $(`input[name="cuts[${processId}][]"]:checked`);
            let totalSelectedWeight = 0;

            $selectedCuts.each(function() {
                const $row = $(this).closest('tr');
                const weight = parseFloat($row.find('td:nth-child(6)').text()) || 0; // Weight (TON)
                totalSelectedWeight += weight;
            });

            $processGrossWeightInput.val(totalSelectedWeight.toFixed(3));
        }

        /**
         * Updates individual weights for a CRS process.
         * @param {number} processIndex - The index of the process.
         */
        function updateIndividualWeights(processIndex) {
            const $processCard = $(`.process-section .card[data-process-index="${processIndex}"]`);
            const $rows = $processCard.find('table tbody tr');
            let individualWeights = [];

            $rows.each(function() {
                const $row = $(this);
                const quantity = parseInt($row.find('td:nth-child(5)').text()) || 0;
                const totalWeight = parseFloat($row.find('td:nth-child(6)').text()) || 0;
                const individualWeight = quantity > 0 ? totalWeight / quantity : 0;
                for (let i = 0; i < quantity; i++) {
                    individualWeights.push(individualWeight.toFixed(3));
                }
            });

            const $individualWeightsSpan = $processCard.find(`.individual-weights[data-process-index="${processIndex}"]`);
            if ($individualWeightsSpan.length && individualWeights.length > 0) {
                $individualWeightsSpan.text('Individual Weights (TON): ' + individualWeights.join(', '));
            } else if ($individualWeightsSpan.length) {
                $individualWeightsSpan.text('Individual Weights (TON): N/A');
            }
        }

        /**
         * Updates packing details for a process (CRS or CTL).
         * @param {number} processId - The ID of the process.
         * @param {number} processIndex - The index of the process.
         * @param {string} processType - The type of process ('crs' or 'ctl').
         */
        function updateProcessPackingDetails(processId, processIndex, processType) {
            const $processCard = $(`.process-section .card[data-process-index="${processIndex}"]`);
            const coilID = 508;
            const thickness = {{ $plan->coil->thickness ?? 0 }};
            const materialDensity = 7.85; // Assuming steel density in g/cm³
            const grossWeight = {{ $plan->coil->net_weight ?? 0 }} * 1000; // Convert TON to kg
            const coilWidth = {{ $plan->coil->width ?? 0 }};

            if (processType === 'crs') {
                const $odInput = $(`#process_od_${processId}`);
                const $buildUpInput = $(`#process_build_up_${processId}`);
                const $packetInput = $(`#process_packets_${processId}`);
                const $coilQtyInput = $(`#process_coil_qty_${processId}`);
                const od = parseFloat($odInput.val()) || 0;
                const packetCount = parseInt($packetInput.val()) || 0;
                const maxQuantity = parseInt($packetInput.data('max-quantity')) || 0;

                // Validate OD and calculate Build Up
                const $odError = $odInput.siblings('.error-message');
                if (od <= coilID) {
                    $odError.text(`OD must be greater than ${coilID} mm.`).show();
                    $buildUpInput.val('');
                } else {
                    $odError.hide();
                    const buildUp = ((od - coilID) / 2).toFixed(2);
                    $buildUpInput.val(buildUp);
                }

                // Validate packet count
                const $packetError = $packetInput.siblings('.error-message');
                if (packetCount > maxQuantity) {
                    $packetError.text(`Warning: Packet count exceeds maximum quantity (${maxQuantity}).`).show();
                } else {
                    $packetError.hide();
                }

                // Set coil quantity
                $coilQtyInput.val(maxQuantity);
            } else if (processType === 'ctl') {
                const $qtyPerPacketInput = $(`#process_qty_per_packet_${processId}`);
                const $packetCountInput = $(`#process_packets_${processId}`);
                const totalQuantity = parseInt($qtyPerPacketInput.data('total-quantity')) || 0;
                const qtyPerPacket = parseInt($qtyPerPacketInput.val()) || 0;
                const packetCount = parseInt($packetCountInput.val()) || 0;
                const $error = $qtyPerPacketInput.siblings('.error-message');

                // Calculate production weight
                const $rows = $processCard.find('table tbody tr');
                let productionWeight = 0;
                $rows.each(function() {
                    const $row = $(this);
                    const width = parseFloat($row.find('td:nth-child(3)').text()) || 0;
                    const length = parseFloat($row.find('td:nth-child(4)').text()) || 0;
                    const quantity = parseInt($row.find('td:nth-child(5)').text()) || 0;
                    if (width && length && quantity) {
                        const intermediateProduct = thickness * width * length * materialDensity;
                        let productionWeightPerUnit = intermediateProduct / 1000000000; // Convert to TON
                        productionWeightPerUnit = productionWeightPerUnit.toFixed(3);
                        productionWeight += productionWeightPerUnit * quantity;
                    }
                });
                productionWeight = productionWeight.toFixed(3);

                // Calculate qty per packet
                if (packetCount > 0) {
                    const qtyPerPacketResult = Math.floor(totalQuantity / packetCount);
                    $qtyPerPacketInput.val(qtyPerPacketResult);
                }

                // Validate total quantity
                if (qtyPerPacket > 0 && packetCount > 0) {
                    const totalPacketsQty = qtyPerPacket * packetCount;
                    if (totalPacketsQty > totalQuantity) {
                        $error.text(`Warning: Total quantity (${totalPacketsQty}) exceeds maximum (${totalQuantity}).`)
                            .show();
                    } else {
                        $error.hide();
                    }
                } else {
                    $error.hide();
                }

                // Validate packet count
                const $packetError = $packetCountInput.siblings('.error-message');
                if (packetCount > totalQuantity) {
                    $packetError.text(`Warning: Packet count exceeds maximum quantity (${totalQuantity}).`).show();
                } else {
                    $packetError.hide();
                }
            }
        }

        /**
         * Updates packing details for a specific dimension.
         * @param {number} processId - The ID of the process.
         * @param {number} processIndex - The index of the process.
         * @param {string} processType - The type of process ('crs' or 'ctl').
         * @param {jQuery} $packingDetails - The jQuery object for the packing details section.
         */
        function updateDimensionPackingDetails(processId, processIndex, processType, $packingDetails) {
            const coilID = 508;
            const thickness = {{ $plan->coil->thickness ?? 0 }};
            const materialDensity = 7.85; // Assuming steel density in g/cm³
            const grossWeight = {{ $plan->coil->net_weight ?? 0 }} * 1000; // Convert TON to kg
            const coilWidth = {{ $plan->coil->width ?? 0 }};

            const cutId = $packingDetails.closest('tr').prev().find('.dimension-cut-checkbox').data('cut-id');
            const $odInput = $(`#cut_od_${processId}_${cutId}`);
            const $buildUpInput = $(`#cut_build_up_${processId}_${cutId}`);
            const $packetInput = $(`#cut_packets_${processId}_${cutId}`);
            const $coilQtyInput = $(`#cut_coil_qty_${processId}_${cutId}`);
            const $qtyPerPacketInput = $(`#cut_qty_per_packet_${processId}_${cutId}`);

            const maxQuantity = parseInt($packetInput.data('max-quantity')) || 0;
            const totalQuantity = parseInt($qtyPerPacketInput ? $qtyPerPacketInput.data('total-quantity') : 0) || 0;

            if (processType === 'crs') {
                const od = parseFloat($odInput.val()) || 0;
                const packetCount = parseInt($packetInput.val()) || 0;

                // Validate OD and calculate Build Up
                const $odError = $odInput.siblings('.error-message');
                if (od <= coilID) {
                    $odError.text(`OD must be greater than ${coilID} mm.`).show();
                    $buildUpInput.val('');
                } else {
                    $odError.hide();
                    const buildUp = ((od - coilID) / 2).toFixed(2);
                    $buildUpInput.val(buildUp);
                }

                // Validate packet count
                const $packetError = $packetInput.siblings('.error-message');
                if (packetCount > maxQuantity) {
                    $packetError.text(`Warning: Packet count exceeds maximum quantity (${maxQuantity}).`).show();
                } else {
                    $packetError.hide();
                }

                $coilQtyInput.val(maxQuantity);
            } else if (processType === 'ctl') {
                const qtyPerPacket = parseInt($qtyPerPacketInput.val()) || 0;
                const packetCount = parseInt($packetInput.val()) || 0;
                const $error = $qtyPerPacketInput.siblings('.error-message');

                // Calculate qty per packet
                if (packetCount > 0) {
                    const qtyPerPacketResult = Math.floor(totalQuantity / packetCount);
                    $qtyPerPacketInput.val(qtyPerPacketResult);
                }

                // Validate total quantity
                if (qtyPerPacket > 0 && packetCount > 0) {
                    const totalPacketsQty = qtyPerPacket * packetCount;
                    if (totalPacketsQty > totalQuantity) {
                        $error.text(`Warning: Total quantity (${totalPacketsQty}) exceeds maximum (${totalQuantity}).`)
                            .show();
                    } else {
                        $error.hide();
                    }
                } else {
                    $error.hide();
                }

                // Validate packet count
                const $packetError = $packetInput.siblings('.error-message');
                if (packetCount > totalQuantity) {
                    $packetError.text(`Warning: Packet count exceeds maximum quantity (${totalQuantity}).`).show();
                } else {
                    $packetError.hide();
                }
            }
        }

        /**
         * Toggles the visibility of coil dispatch or scrap fields based on the selected option.
         * @param {string} option - The selected option ('dispatch' or 'scrap').
         */
        function toggleCoilDispatch(option) {
            const coilDispatchFields = $('#coil_dispatch_fields');
            const coilScrapMessage = $('#coil_scrap_message');
            const coilBalanceWeightSpan = $('#coilBalanceWeight');
            const coilBalanceWeightInput = $('#coil_balance_weight_input');
            const coilScrapInput = $('#coil_scrap_input');
            const originalBalanceWeight = {{ max(0, $plan->balance_weight) }};

            if (option === 'dispatch') {
                coilDispatchFields.show();
                coilScrapMessage.hide();
                coilBalanceWeightSpan.text(originalBalanceWeight.toFixed(3));
                coilBalanceWeightInput.val(originalBalanceWeight.toFixed(3));
                coilScrapInput.val('0');
                coilDispatchFields.find('input, textarea').attr('required', true);
            } else if (option === 'scrap') {
                if (confirm('Are you sure you want to add this to scrap?')) {
                    coilDispatchFields.hide();
                    coilScrapMessage.show();
                    coilBalanceWeightSpan.text('0.000');
                    coilBalanceWeightInput.val('0.000');
                    coilScrapInput.val(originalBalanceWeight.toFixed(3));
                    coilDispatchFields.find('input, textarea').removeAttr('required');
                } else {
                    $('input[name="coil_dispatch_option"][value="dispatch"]').prop('checked', true);
                }
            }
        }

        /**
         * Toggles the visibility of scrap details based on the selected option.
         */
        function toggleScrapDetails() {
            const scrapDetails = $('#scrap_details');
            const isScrap = $('input[name="is_scrap"]:checked').val();
            scrapDetails.toggle(isScrap === '1');
            if (isScrap === '1') {
                scrapDetails.find('input:not([readonly]), textarea').attr('required', true);
            } else {
                scrapDetails.find('input, textarea').removeAttr('required');
            }
        }

        /**
         * Toggles the visibility of process-level packing details based on process checkbox.
         * @param {number} processId - The ID of the process.
         */
        function toggleProcessPackingDetails(processId) {
            const $packingDetails = $(`#process-packing-details-${processId}`);
            const $checkbox = $(`input[name="process_id[]"][value="${processId}"]`);
            const isChecked = $checkbox.is(':checked');
            $packingDetails.toggle(isChecked);
            const $packingFields = $packingDetails.find('input:not([readonly]), textarea');
            $packingFields.each(function() {
                if (isChecked) {
                    $(this).attr('required', 'required');
                } else {
                    $(this).removeAttr('required');
                }
            });
        }

        /**
         * Toggles the visibility of dimension-level packing details and manages required attributes.
         * @param {number} processId - The ID of the process.
         * @param {number} cutId - The ID of the cut.
         */
        function toggleDimensionPackingDetails(processId, cutId) {
            const $packingDetails = $(`#dimension-packing-details-${processId}-${cutId}`);
            const $checkbox = $(`#dimension_packing_${processId}_${cutId}`);
            const isChecked = $checkbox.is(':checked');

            if ($packingDetails.length) {
                $packingDetails.css('display', isChecked ? 'block' : 'none');

                const $packingFields = $packingDetails.find('input:not([readonly]), textarea');
                $packingFields.each(function() {
                    if (isChecked) {
                        $(this).attr('required', 'required');
                    } else {
                        $(this).removeAttr('required');
                        $(this).val(''); // Clear fields when hidden
                    }
                });
            } else {
                console.warn(`Packing details section for processId ${processId} and cutId ${cutId} not found.`);
            }
        }

        /**
         * Validates the form on submission.
         */
        $('form').submit(function(e) {
            let valid = true;
            const totalProdWt = $('#total_prod_wt');
            const remCoilWt = $('#rem_coil_wt');
            const coilDispatchOption = $('input[name="coil_dispatch_option"]:checked').val();
            const isScrap = $('input[name="is_scrap"]:checked').val();
            const processChecked = $('input[name="process_id[]"]:checked').length;

            // Ensure at least one action is selected
            if (!processChecked && isScrap !== '1' && (!coilDispatchOption || (coilDispatchOption === 'dispatch' &&
                    !$('#coil_gross_weight').val()))) {
                alert('Please select at least one process, enable scrap, or provide coil dispatch details.');
                e.preventDefault();
                return;
            }

            // Validate total production weight
            if ($.trim(totalProdWt.val()) === '') {
                valid = false;
                totalProdWt.addClass('input-error');
                totalProdWt.after('<div class="error-message">This field is required.</div>');
            } else {
                totalProdWt.removeClass('input-error');
                totalProdWt.siblings('.error-message').remove();
            }

            // Validate remaining coil weight
            if ($.trim(remCoilWt.val()) === '') {
                valid = false;
                remCoilWt.addClass('input-error');
                remCoilWt.after('<div class="error-message">This field is required.</div>');
            } else {
                remCoilWt

.removeClass('input-error');
                remCoilWt.siblings('.error-message').remove();
            }

            // Validate coil dispatch fields
            if (coilDispatchOption === 'dispatch' && $('#coil_gross_weight').val()) {
                const $coilLocation = $('#coil_location');
                if ($.trim($coilLocation.val()) === '') {
                    valid = false;
                    $coilLocation.addClass('input-error');
                    $('#coil_location-error').text('Dispatch location is required.').show();
                } else {
                    $coilLocation.removeClass('input-error');
                    $('#coil_location-error').hide();
                }
            }

            // Validate scrap fields
            if (isScrap === '1') {
                const $scrapLocation = $('#scrap_location');
                if ($.trim($scrapLocation.val()) === '') {
                    valid = false;
                    $scrapLocation.addClass('input-error');
                    $('#scrap_location-error').text('Scrap location is required.').show();
                } else {
                    $scrapLocation.removeClass('input-error');
                    $('#scrap_location-error').hide();
                }
            }

            // Validate process dispatch fields
            $('input[name="process_id[]"]:checked').each(function() {
                const processId = $(this).val();

                // Validate that at least one cut is selected for the process
                const $selectedCuts = $(`input[name="cuts[${processId}][]"]:checked`);
                if ($selectedCuts.length === 0) {
                    valid = false;
                    alert(`Please select at least one dimension for Process ${processId}.`);
                    return false; // Break the each loop
                }

                const $locationInput = $(`#process_location_${processId}`);
                if ($.trim($locationInput.val()) === '') {
                    valid = false;
                    $locationInput.addClass('input-error');
                    $(`#process_location_${processId}-error`).text('Dispatch location is required.').show();
                } else {
                    $locationInput.removeClass('input-error');
                    $(`#process_location_${processId}-error`).hide();
                }

                const processType = $(`#process-${processId}`).find('.badge.bg-info').text()
                    .toLowerCase() === 'line 1' ? 'crs' : 'ctl';
                const $processPackingDetails = $(`#process-packing-details-${processId}`);

                // Validate process-level packing details if visible
                if ($processPackingDetails.is(':visible')) {
                    if (processType === 'crs') {
                        const $odInput = $(`#process_od_${processId}`);
                        const od = parseFloat($odInput.val()) || 0;
                        if (od <= 0) {
                            valid = false;
                            $odInput.addClass('input-error');
                            $(`#process_od_${processId}-error`).text('OD must be a positive number.')
                                .show();
                        } else {
                            $odInput.removeClass('input-error');
                            $(`#process_od_${processId}-error`).hide();
                        }

                        const $packetInput = $(`#process_packets_${processId}`);
                        const packetCount = parseInt($packetInput.val()) || 0;
                        if (packetCount <= 0) {
                            valid = false;
                            $packetInput.addClass('input-error');
                            $(`#process_packets_${processId}-error`).text(
                                'Packet count must be greater than 0.').show();
                        } else {
                            $packetInput.removeClass('input-error');
                            $(`#process_packets_${processId}-error`).hide();
                        }
                    } else if (processType === 'ctl') {
                        const $qtyPerPacketInput = $(`#process_qty_per_packet_${processId}`);
                        const qtyPerPacket = parseInt($qtyPerPacketInput.val()) || 0;
                        if (qtyPerPacket <= 0) {
                            valid = false;
                            $qtyPerPacketInput.addClass('input-error');
                            $(`#process_qty_per_packet_${processId}-error`).text(
                                'Quantity per packet must be greater than 0.').show();
                        } else {
                            $qtyPerPacketInput.removeClass('input-error');
                            $(`#process_qty_per_packet_${processId}-error`).hide();
                        }

                        const $packetInput = $(`#process_packets_${processId}`);
                        const packetCount = parseInt($packetInput.val()) || 0;
                        if (packetCount <= 0) {
                            valid = false;
                            $packetInput.addClass('input-error');
                            $(`#process_packets_${processId}-error`).text(
                                'Packet count must be greater than 0.').show();
                        } else {
                            $packetInput.removeClass('input-error');
                            $(`#process_packets_${processId}-error`).hide();
                        }

                        const totalQuantity = parseInt($qtyPerPacketInput.data('total-quantity')) || 0;
                        const totalPacketsQty = qtyPerPacket * packetCount;
                        if (totalPacketsQty > totalQuantity) {
                            valid = false;
                            $qtyPerPacketInput.addClass('input-error');
                            $(`#process_qty_per_packet_${processId}-error`).text(
                                `Total quantity (${totalPacketsQty}) exceeds maximum (${totalQuantity}).`
                            ).show();
                        }
                    }
                }

                // Validate dimension-level packing details
                $selectedCuts.each(function() {
                    const cutId = $(this).val();
                    const isDimensionPackingIncluded = $(`#dimension_packing_${processId}_${cutId}`)
                        .is(':checked');

                    if (isDimensionPackingIncluded) {
                        if (processType === 'crs') {
                            const $odInput = $(`#cut_od_${processId}_${cutId}`);
                            const od = parseFloat($odInput.val()) || 0;
                            if (od <= 0) {
                                valid = false;
                                $odInput.addClass('input-error');
                                $(`#cut_od_${processId}_${cutId}-error`).text(
                                    'OD must be a positive number.').show();
                            } else {
                                $odInput.removeClass('input-error');
                                $(`#cut_od_${processId}_${cutId}-error`).hide();
                            }

                            const $packetInput = $(`#cut_packets_${processId}_${cutId}`);
                            const packetCount = parseInt($packetInput.val()) || 0;
                            if (packetCount <= 0) {
                                valid = false;
                                $packetInput.addClass('input-error');
                                $(`#cut_packets_${processId}_${cutId}-error`).text(
                                    'Packet count must be greater than 0.').show();
                            } else {
                                $packetInput.removeClass('input-error');
                                $(`#cut_packets_${processId}_${cutId}-error`).hide();
                            }
                        } else if (processType === 'ctl') {
                            const $qtyPerPacketInput = $(
                                `#cut_qty_per_packet_${processId}_${cutId}`);
                            const qtyPerPacket = parseInt($qtyPerPacketInput.val()) || 0;
                            if (qtyPerPacket <= 0) {
                                valid = false;
                                $qtyPerPacketInput.addClass('input-error');
                                $(`#cut_qty_per_packet_${processId}_${cutId}-error`).text(
                                    'Quantity per packet must be greater than 0.').show();
                            } else {
                                $qtyPerPacketInput.removeClass('input-error');
                                $(`#cut_qty_per_packet_${processId}_${cutId}-error`).hide();
                            }

                            const $packetInput = $(`#cut_packets_${processId}_${cutId}`);
                            const packetCount = parseInt($packetInput.val()) || 0;
                            if (packetCount <= 0) {
                                valid = false;
                                $packetInput.addClass('input-error');
                                $(`#cut_packets_${processId}_${cutId}-error`).text(
                                    'Packet count must be greater than 0.').show();
                            } else {
                                $packetInput.removeClass('input-error');
                                $(`#cut_packets_${processId}_${cutId}-error`).hide();
                            }

                            const totalQuantity = parseInt($qtyPerPacketInput.data(
                                'total-quantity')) || 0;
                            const totalPacketsQty = qtyPerPacket * packetCount;
                            if (totalPacketsQty > totalQuantity) {
                                valid = false;
                                $qtyPerPacketInput.addClass('input-error');
                                $(`#cut_qty_per_packet_${processId}_${cutId}-error`).text(
                                    `Total quantity (${totalPacketsQty}) exceeds maximum (${totalQuantity}).`
                                ).show();
                            }
                        }
                    }
                });
            });

            if (!valid) {
                alert('Please fill in all required fields correctly.');
                e.preventDefault();
            }
        });
    </script>
@endsection
