@extends('layouts.structure')

@section('content')
    <style>
        .container {
            margin-top: 80px;
        }

        .card-header {
            position: relative;
            z-index: 1;
        }

        .remove-coil {
            cursor: pointer;
            color: red;
            font-size: 1.2em;
            display: none;
        }

        .coil-row.new {
            background-color: #f8f9fa;
            transition: background-color 1s ease;
        }

        .invalid-feedback {
            display: none;
        }

        .is-invalid~.invalid-feedback {
            display: block;
        }

        .autocomplete-suggestions {
            position: absolute;
            z-index: 1000;
            background: white;
            border: 1px solid #ccc;
            max-height: 200px;
            overflow-y: auto;
            width: 100%;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }

        .autocomplete-suggestions ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .autocomplete-suggestions li {
            padding: 8px;
            cursor: pointer;
        }

        .autocomplete-suggestions li:hover {
            background-color: #f0f0f0;
        }
    </style>

    <div class="container">
        <div class="card mb-5">
            <div class="card-header bg-primary text-white">
                <h5 class="mt-2 mb-0">Create Inward</h5>
            </div>
            <div class="card-body p-4">
                <!-- Success/Error Alerts -->
                <div class="alert alert-success alert-dismissible fade show d-none" role="alert" id="success-alert">
                    Inward created successfully.
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <div class="alert alert-danger alert-dismissible fade show d-none" role="alert" id="error-alert">
                    Failed to create inward.
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>

                <form action="{{ route('inward.store') }}" method="POST" class="row g-3" enctype="multipart/form-data"
                    id="inward-form">
                    @csrf
                    <!-- Card 1: Inward & Vehicle Details -->
                    <div class="mb-4">
                        <div class="card-header bg-light">
                            <h5>Inward & Vehicle Details</h5>
                        </div>
                        <div class="card-body row">
                            <div class="col-md-4">
                                <label class="form-label required" for="plant_id">Select Plant</label>
                                <span class="text-danger">*</span>
                                <select class="form-control @error('plant_id') is-invalid @enderror" id="plant_id"
                                    name="plant_id" required onchange="handleChange(this)">
                                    <option value="">--Select Plant--</option>
                                    @foreach ($plants as $plant)
                                        <option value="{{ $plant->id }}"
                                            {{ old('plant_id') == $plant->id ? 'selected' : '' }}>
                                            {{ $plant->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('plant_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">Please select a plant.</div>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label required" for="inward_code">Inward Code</label>
                                <span class="text-danger">*</span>
                                <input type="text" class="form-control" name="inward_code" id="inward_code"
                                    value="{{ $nextInwardCode }}" readonly>
                                <div class="invalid-feedback">Inward code is required.</div>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label required" for="inward_date">Inward Date</label>
                                <span class="text-danger">*</span>
                                <input type="date" class="form-control @error('inward_date') is-invalid @enderror"
                                    id="inward_date" name="inward_date" value="{{ old('inward_date', '2025-04-26') }}"
                                    required max="{{ date('Y-m-d') }}">
                                @error('inward_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">Please select a valid date.</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mt-3">
                                <label class="form-label required" for="grn_no">GRN No.</label>
                                <span class="text-danger">*</span>
                                <input type="text" class="form-control" id="grn_no" name="grn_no"
                                    value="{{ $grn_no }}" readonly required>
                                <div class="invalid-feedback">GRN No. is required.</div>
                            </div>
                            <div class="col-md-4 mt-3">
                                <label class="form-label required" for="vehicle_registration_number">Vehicle Registration
                                    Number</label>
                                <span class="text-danger">*</span>
                                <input type="text"
                                    class="form-control @error('vehicle_registration_number') is-invalid @enderror"
                                    id="vehicle_registration_number" name="vehicle_registration_number"
                                    value="{{ old('vehicle_registration_number') }}" required maxlength="20">
                                @error('vehicle_registration_number')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">Vehicle registration number is required.</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mt-3">
                                <label class="form-label required" for="challan_no">57 F4 Challan No</label>
                                <span class="text-danger">*</span>
                                <input type="text" class="form-control @error('challan_no') is-invalid @enderror"
                                    id="challan_no" name="challan_no" value="{{ old('challan_no') }}" required
                                    maxlength="50">
                                @error('challan_no')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">Challan No. is required.</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mt-3">
                                <label class="form-label required" for="challan_date">Challan Date</label>
                                <span class="text-danger">*</span>
                                <input type="date" class="form-control @error('challan_date') is-invalid @enderror"
                                    id="challan_date" name="challan_date" value="{{ old('challan_date') }}" required
                                    max="{{ date('Y-m-d') }}">
                                @error('challan_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">Please select a valid challan date.</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Card 2: Client Details -->
                    <div class="mb-4">
                        <div class="card-header bg-light">
                            <h5>Client Details</h5>
                        </div>
                        <div class="card-body row">
                            <div class="col-md-4">
                                <label class="form-label required" for="client_id">Select Client Name</label>
                                <span class="text-danger">*</span>
                                <select class="form-control @error('client_id') is-invalid @enderror" id="client_id"
                                    name="client_id" required>
                                    <option value="">--Select Client Name--</option>
                                    @foreach ($clients as $client)
                                        <option value="{{ $client->client_id }}"
                                            {{ old('client_id') == $client->client_id ? 'selected' : '' }}>
                                            {{ $client->client_name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('client_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">Please select a client.</div>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label required" for="manufacturer_id">Select Manufacturer</label>
                                <span class="text-danger">*</span>
                                <select class="form-control @error('manufacturer_id') is-invalid @enderror"
                                    id="manufacturer_id" name="manufacturer_id" required>
                                    <option value="">--Select Manufacturer Name--</option>
                                    @foreach ($manufacturers as $manufacturer)
                                        <option value="{{ $manufacturer->manufacturer_id }}"
                                            {{ old('manufacturer_id') == $manufacturer->manufacturer_id ? 'selected' : '' }}>
                                            {{ $manufacturer->manufacturer_name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('manufacturer_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">Please select a manufacturer.</div>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label" for="invoice_no">Client Invoice Number</label>
                                <input type="text" class="form-control @error('invoice_no') is-invalid @enderror"
                                    id="invoice_no" name="invoice_no" value="{{ old('invoice_no') }}" maxlength="50">
                                @error('invoice_no')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">Invalid invoice number.</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mt-3">
                                <label class="form-label required" for="invoice_date">Invoice Date</label>
                                <span class="text-danger">*</span>
                                <input type="date" class="form-control @error('invoice_date') is-invalid @enderror"
                                    id="invoice_date" name="invoice_date" value="{{ old('invoice_date') }}" required
                                    max="{{ date('Y-m-d') }}">
                                @error('invoice_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">Please select a valid invoice date.</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mt-3">
                                <label class="form-label required" for="upload_invoice">Upload Invoice</label>
                                <span class="text-danger">*</span>
                                <input type="file" class="form-control @error('upload_invoice') is-invalid @enderror"
                                    id="upload_invoice" name="upload_invoice" accept=".pdf,.jpg,.png" required>
                                @error('upload_invoice')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">Please upload an invoice file.</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mt-3">
                                <label class="form-label required" for="hsn_code">HSN Code</label>
                                <span class="text-danger">*</span>
                                <input type="text" class="form-control @error('hsn_code') is-invalid @enderror"
                                    id="hsn_code" name="hsn_code" value="{{ old('hsn_code') }}" required
                                    maxlength="50">
                                @error('hsn_code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @else
                                    <div class="invalid-feedback">HSN code is required.</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Card 3: Coil Details -->
                    <div class="mb-4">
                        <div class="card-header bg-light d-flex justify-content-between align-items-center">
                            <h5>Coil Details</h5>
                        </div>
                        <div class="card-body" id="coil-container">
                            <!-- Initial Coil Row -->
                            <div class="coil-row mb-3 border p-3 rounded" data-index="0">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <h6>Coil 1</h6>
                                    <span class="remove-coil">×</span>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label class="form-label required" for="coils[0][crr_no]">CRR No.</label>
                                        <span class="text-danger">*</span>
                                        <input type="text"
                                            class="form-control @error('coils.0.crr_no') is-invalid @enderror"
                                            id="coils[0][crr_no]" name="coils[0][crr_no]" value="{{ $nextCrrNo }}"
                                            readonly required>
                                        @error('coils.0.crr_no')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">CRR No. is required.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label required" for="coils[0][coil_no]">Customer Coil No./Batch
                                            No.</label>
                                        <span class="text-danger">*</span>
                                        <input type="text"
                                            class="form-control @error('coils.0.coil_no') is-invalid @enderror"
                                            id="coils[0][coil_no]" name="coils[0][coil_no]"
                                            value="{{ old('coils.0.coil_no') }}" required maxlength="50">
                                        @error('coils.0.coil_no')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Coil No. is required.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label required" for="grade_id_0">Grade</label>
                                        <span class="text-danger">*</span>
                                        <input type="text"
                                            class="form-control grade-input @error('coils.0.grade_id') is-invalid @enderror"
                                            id="grade_id_0" data-index="0" data-selected="false" required>
                                        <input type="hidden" name="coils[0][grade_id]" id="grade_id_hidden_0"
                                            class="grade-id-hidden">
                                        <input type="hidden" name="coils[0][grade_name]" id="grade_name_hidden_0"
                                            class="grade-name-hidden">
                                        <div id="grade_suggestions_0" class="autocomplete-suggestions"></div>
                                        @error('coils.0.grade_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Please enter or select a grade.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mt-3">
                                        <label class="form-label required" for="coils[0][thickness]">Thickness (in
                                            mm)</label>
                                        <span class="text-danger">*</span>
                                        <input type="number" step="0.01"
                                            class="form-control @error('coils.0.thickness') is-invalid @enderror"
                                            id="coils[0][thickness]" name="coils[0][thickness]"
                                            value="{{ old('coils.0.thickness') }}" required min="0">
                                        @error('coils.0.thickness')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Thickness is required and must be positive.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mt-3">
                                        <label class="form-label required" for="coils[0][width]">Width (in mm)</label>
                                        <span class="text-danger">*</span>
                                        <input type="number" step="0.01"
                                            class="form-control @error('coils.0.width') is-invalid @enderror"
                                            id="coils[0][width]" name="coils[0][width]"
                                            value="{{ old('coils.0.width') }}" required min="0">
                                        @error('coils.0.width')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Width is required and must be positive.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mt-3">
                                        <label class="form-label required" for="coils[0][net_weight]">Net Weight (in
                                            Ton)</label>
                                        <span class="text-danger">*</span>
                                        <input type="number" step="0.001"
                                            class="form-control @error('coils.0.net_weight') is-invalid @enderror"
                                            id="coils[0][net_weight]" name="coils[0][net_weight]"
                                            value="{{ old('coils.0.net_weight') }}" required min="0">
                                        @error('coils.0.net_weight')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Net weight is required and must be positive.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mt-3">
                                        <label class="form-label required" for="coils[0][gross_weight]">Gross Weight (in
                                            Ton)</label>

                                        <input type="number" step="0.001"
                                            class="form-control @error('coils.0.gross_weight') is-invalid @enderror"
                                            id="coils[0][gross_weight]" name="coils[0][gross_weight]"
                                            value="{{ old('coils.0.gross_weight') }}" min="0">
                                        @error('coils.0.gross_weight')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Gross weight is required and must be positive.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mt-3" style="display:none">
                                        <label class="form-label" for="coils[0][used_coil]">Used Coil (in Ton)</label>
                                        <input type="number" step="0.001" class="form-control"
                                            id="coils[0][used_coil]" name="coils[0][used_coil]" value="0" readonly>
                                        <div class="invalid-feedback">Used coil must be non-negative.</div>
                                    </div>
                                    <div class="col-md-4 mt-3" style="display:none">
                                        <label class="form-label" for="coils[0][balance_coil]">Balance Coil (in
                                            Ton)</label>
                                        <input type="number" step="0.001"
                                            class="form-control @error('coils.0.balance_coil') is-invalid @enderror"
                                            id="coils[0][balance_coil]" name="coils[0][balance_coil]"
                                            value="{{ old('coils.0.balance_coil') }}" readonly>
                                        @error('coils.0.balance_coil')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Balance coil must be non-negative.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mt-3" style="display:none">
                                        <label class="form-label" for="coils[0][scrap_wt]">Scrap Weight (in Ton)</label>
                                        <input type="number" step="0.001" class="form-control"
                                            id="coils[0][scrap_wt]" name="coils[0][scrap_wt]" value="0" readonly>
                                        <div class="invalid-feedback">Scrap weight must be non-negative.</div>
                                    </div>
                                    <!-- Material Type Dropdown -->
                                    <div class="col-md-4 mt-3">
                                        <label class="form-label required" for="coils[0][material_type_id]">Material
                                            Type</label>
                                        <span class="text-danger">*</span>
                                        <select
                                            class="form-control material-type-select @error('coils.0.material_type_id') is-invalid @enderror"
                                            id="coils[0][material_type_id]" name="coils[0][material_type_id]" required>
                                            <option value="">--Select Material Type--</option>
                                            @foreach ($materialTypes as $materialType)
                                                <option value="{{ $materialType->id }}"
                                                    data-density="{{ $materialType->density }}"
                                                    {{ old('coils.0.material_type_id') == $materialType->id ? 'selected' : '' }}>
                                                    {{ $materialType->material_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('coils.0.material_type_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Please select a material type.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mt-3">
                                        <label class="form-label required" for="coils[0][basic_rate_per_ton]">Basic Rate
                                            Per Ton</label>
                                        <span class="text-danger">*</span>
                                        <input type="number" step="0.01"
                                            class="form-control @error('coils.0.basic_rate_per_ton') is-invalid @enderror"
                                            id="coils[0][basic_rate_per_ton]" name="coils[0][basic_rate_per_ton]"
                                            value="{{ old('coils.0.basic_rate_per_ton') }}" required min="0">
                                        @error('coils.0.basic_rate_per_ton')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Basic rate is required and must be positive.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mt-3">
                                        <label class="form-label" for="coils[0][location]">Location</label>
                                        <input type="text"
                                            class="form-control @error('coils.0.location') is-invalid @enderror"
                                            id="coils[0][location]" name="coils[0][location]"
                                            value="{{ old('coils.0.location') }}">
                                        @error('coils.0.location')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Invalid location.</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mt-3">
                                        <label class="form-label" for="coils[0][remark]">Remark</label>
                                        <input type="text"
                                            class="form-control @error('coils.0.remark') is-invalid @enderror"
                                            id="coils[0][remark]" name="coils[0][remark]"
                                            value="{{ old('coils.0.remark') }}">
                                        @error('coils.0.remark')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">Invalid remark.</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 d-flex justify-content-end">
                        <div class="d-flex gap-3">
                            <button type="button" class="btn btn-primary btn-sm" id="add-coil">Add Coil</button>

                            <button type="submit" class="btn btn-success btn-sm px-4">Save</button>
                            <a href="{{ route('inward.index') }}" class="btn btn-danger btn-sm px-4">Cancel</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- jQuery and Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        jQuery.noConflict();
        jQuery(document).ready(function($) {
            console.log('jQuery loaded, script running');

            // Uppercase inputs
            $('#vehicle_registration_number, #challan_no, input[name*="coil_no"]').on('input', function() {
                $(this).val($(this).val().toUpperCase());
            });

            // Restrict date inputs to today or earlier
            const today = new Date().toISOString().split('T')[0];
            $('#inward_date, #invoice_date, #challan_date').attr('max', today).val(today);

            // Initialize CRR No. state
            let crrState = {
                letterCode: 'AA',
                number: 1
            };
            const initialCrrNo = $('#coils\\[0\\]\\[crr_no\\]').val() || 'CRRAA00001';
            const crrMatch = initialCrrNo.match(/CRR([A-Z]{2})(\d{5})/);
            if (crrMatch) {
                crrState.letterCode = crrMatch[1];
                crrState.number = parseInt(crrMatch[2]) + 1;
            }
            console.log('Initial CRR State:', crrState);

            function generateCrrNo() {
                const prefix = 'CRR';
                const letterCode = crrState.letterCode;
                const number = crrState.number.toString().padStart(5, '0');
                const crrNo = `${prefix}${letterCode}${number}`;
                console.log('Generated CRR No.:', crrNo);
                crrState.number++;
                if (crrState.number > 99999) {
                    crrState.number = 1;
                    crrState.letterCode = incrementLetterCode(crrState.letterCode);
                }
                return crrNo;
            }


            function incrementLetterCode(code) {
                let [first, second] = code.split('');
                if (second === 'Z') {
                    if (first === 'Z') {
                        return 'AA';
                    }
                    first = String.fromCharCode(first.charCodeAt(0) + 1);
                    second = 'A';
                } else {
                    second = String.fromCharCode(second.charCodeAt(0) + 1);
                }
                return `${first}${second}`;
            }

            // Grade autocomplete
            $(document).on('input', '.grade-input', function() {
                const $this = $(this);
                const query = $this.val().trim();
                const index = $this.data('index');
                const suggestionsContainer = `#grade_suggestions_${index}`;
                console.log(`Grade input for index ${index}:`, query);

                $this.data('selected', false); // Reset selection flag
                $(`#grade_id_hidden_${index}`).val(''); // Clear grade_id
                $(`#grade_name_hidden_${index}`).val(query); // Set grade_name

                if (query.length > 0) {
                    $.ajax({
                        url: "{{ route('grades.search') }}",
                        type: 'GET',
                        data: {
                            query: query
                        },
                        dataType: 'json',
                        success: function(data) {
                            console.log(`Grade suggestions for index ${index}:`, data);
                            let suggestions = '';
                            if (data.length > 0) {
                                suggestions = '<ul class="list-unstyled border p-2 bg-white">';
                                data.forEach(function(grade) {
                                    suggestions +=
                                        `<li class="suggestion-item" data-index="${index}" data-grade-id="${grade.id}">${grade.grade_name}</li>`;
                                });
                                suggestions += '</ul>';
                            }
                            $(suggestionsContainer).html(suggestions).show();
                        },
                        error: function(xhr) {
                            console.error(`Error fetching grades for index ${index}:`, xhr);
                            $(suggestionsContainer).html('').hide();
                        }
                    });
                } else {
                    $(suggestionsContainer).html('').hide();
                    $(`#grade_name_hidden_${index}`).val('');
                }
            });

            // Handle suggestion click
            $(document).on('click', '.suggestion-item', function() {
                const index = $(this).data('index');
                const gradeId = $(this).data('grade-id');
                const gradeName = $(this).text();
                console.log(`Selected grade for index ${index}:`, {
                    id: gradeId,
                    name: gradeName
                });

                $(`#grade_id_${index}`)
                    .val(gradeName)
                    .data('selected', true)
                    .removeClass('is-invalid');
                $(`#grade_id_hidden_${index}`).val(gradeId);
                $(`#grade_name_hidden_${index}`).val('');
                $(`#grade_suggestions_${index}`).html('').hide();
            });

            // Handle form submission
            $('#inward-form').on('submit', function(e) {
                let isValid = true;
                $('.grade-input').each(function() {
                    const $this = $(this);
                    const index = $this.data('index');
                    const value = $this.val().trim();
                    const selected = $this.data('selected');
                    const gradeId = $(`#grade_id_hidden_${index}`).val();
                    const gradeName = $(`#grade_name_hidden_${index}`).val();

                    if (!value) {
                        $this.addClass('is-invalid');
                        isValid = false;
                    } else if (!selected && !gradeId && value) {
                        // New grade: ensure grade_name is set
                        $(`#grade_name_hidden_${index}`).val(value);
                        $this.removeClass('is-invalid');
                    } else if (selected && gradeId) {
                        // Existing grade: ensure grade_id is set
                        $this.removeClass('is-invalid');
                    } else {
                        $this.addClass('is-invalid');
                        isValid = false;
                    }
                });

                if (!isValid) {
                    e.preventDefault();
                    console.log('Form validation failed: Grade fields incomplete');
                }
            });

            // Update balance_coil when net_weight changes
            $(document).on('input', 'input[name*="net_weight"]', function() {
                const $row = $(this).closest('.coil-row');
                const netWeight = parseFloat($(this).val()) || 0;
                $row.find('input[name*="balance_coil"]').val(netWeight.toFixed(3));
            });

            // Dynamic coil rows
            let coilIndex = 1;

            $('#add-coil').on('click', function(e) {
                e.preventDefault();
                console.log('Add Coil button clicked');

                const $coilRow = $('.coil-row:first').clone(true, true);
                $coilRow.attr('data-index', coilIndex);
                $coilRow.find('h6').text(`Coil ${coilIndex + 1}`);
                $coilRow.addClass('new');
                setTimeout(() => $coilRow.removeClass('new'), 1000);

                const newCrrNo = generateCrrNo();

                // Explicitly update grade input
                const $gradeInput = $coilRow.find('.grade-input');
                console.log(
                    `Before grade input update: ID=${$gradeInput.attr('id')}, data-index=${$gradeInput.attr('data-index')}, data=${$gradeInput.data('index')}`
                );
                $gradeInput
                    .attr('id', `grade_id_${coilIndex}`)
                    .attr('data-index', coilIndex)
                    .removeData('index')
                    .data('index', coilIndex)
                    .data('selected', false)
                    .val('')
                    .removeAttr('data-index-old');
                console.log(
                    `After grade input update: ID=${$gradeInput.attr('id')}, data-index=${$gradeInput.attr('data-index')}, data=${$gradeInput.data('index')}`
                );

                // Explicitly update hidden grade inputs
                const $gradeHidden = $coilRow.find('.grade-id-hidden');
                $gradeHidden
                    .attr('id', `grade_id_hidden_${coilIndex}`)
                    .attr('name', `coils[${coilIndex}][grade_id]`)
                    .val('');
                console.log(
                    `Updated hidden grade input: ID=${$gradeHidden.attr('id')}, name=${$gradeHidden.attr('name')}`
                );

                const $gradeNameHidden = $coilRow.find('.grade-name-hidden');
                $gradeNameHidden
                    .attr('id', `grade_name_hidden_${coilIndex}`)
                    .attr('name', `coils[${coilIndex}][grade_name]`)
                    .val('');
                console.log(
                    `Updated hidden grade name input: ID=${$gradeNameHidden.attr('id')}, name=${$gradeNameHidden.attr('name')}`
                );

                // Explicitly update suggestion container
                const $suggestions = $coilRow.find('.autocomplete-suggestions');
                const oldSuggestionsId = $suggestions.attr('id');
                $suggestions
                    .attr('id', `grade_suggestions_${coilIndex}`)
                    .html('')
                    .hide();
                console.log(
                    `Updated suggestion container: ${oldSuggestionsId} -> ${$suggestions.attr('id')}`);

                // Update other inputs and selects
                $coilRow.find('input, select').not('.grade-input, .grade-id-hidden, .grade-name-hidden')
                    .each(function() {
                        const $this = $(this);
                        const oldName = $this.attr('name');
                        const oldId = $this.attr('id');

                        if (oldName && oldId) {
                            const newName = oldName.replace(/coils\[\d+\]/, `coils[${coilIndex}]`);
                            let newId = oldId.replace(/coils\[\d+\]/, `coils[${coilIndex}]`);
                            if (!newId.includes('coils')) {
                                newId = oldId.replace(/\d+/, coilIndex);
                            }

                            $this
                                .attr('name', newName)
                                .attr('id', newId);

                            if ($this.attr('name').includes('crr_no')) {
                                $this.val(newCrrNo).prop('readonly', true);
                            } else if ($this.attr('name').includes('used_coil') || $this.attr('name')
                                .includes('scrap_wt')) {
                                $this.val('0').prop('readonly', true);
                            } else if ($this.attr('name').includes('balance_coil')) {
                                $this.val('').prop('readonly', true);
                            } else if ($this.is('select')) {
                                $this.val('');
                            } else {
                                $this.val('');
                            }
                            $this.removeClass('is-invalid');
                            $this.siblings('.invalid-feedback').not(
                                ':contains("Please enter or select a grade")').remove();
                        }
                    });

                // Debug: Verify all grade inputs in the new row
                $coilRow.find('.grade-input').each(function() {
                    const $this = $(this);
                    console.log(
                        `Post-update grade input: ID=${$this.attr('id')}, data-index=${$this.attr('data-index')}, data=${$this.data('index')}, selected=${$this.data('selected')}`
                    );
                });

                $coilRow.appendTo('#coil-container');
                console.log(`New coil row added, index: ${coilIndex}`);

                // Debug: Verify all grade inputs in DOM
                $('.grade-input').each(function(i) {
                    const $this = $(this);
                    console.log(
                        `DOM grade input ${i}: ID=${$this.attr('id')}, data-index=${$this.attr('data-index')}, data=${$this.data('index')}, selected=${$this.data('selected')}`
                    );
                });

                coilIndex++;
                updateRemoveButtons();
            });

            // Remove coil row
            $(document).on('click', '.remove-coil', function(e) {
                e.preventDefault();
                console.log('Remove Coil button clicked');
                if ($('.coil-row').length > 1) {
                    $(this).closest('.coil-row').remove();
                    updateCoilHeaders();
                    updateRemoveButtons();
                    console.log('Coil row removed, remaining:', $('.coil-row').length);
                }
            });

            // Update coil headers
            function updateCoilHeaders() {
                $('.coil-row').each(function(index) {
                    $(this).find('h6').text(`Coil ${index + 1}`);
                });
            }

            // Show/hide remove buttons
            function updateRemoveButtons() {
                $('.remove-coil').show();
                if ($('.coil-row').length === 1) {
                    $('.coil-row').find('.remove-coil').hide();
                }
            }

            // Client-side validation for coil_no duplicates
            $(document).on('input', 'input[name*="coil_no"]', function() {
                const $input = $(this);
                const value = $input.val().trim();
                const field = 'Coil No.';
                console.log(`Checking ${field}:`, value);
                if (value) {
                    const values = $('input[name*="coil_no"]').map(function() {
                        return $(this).val().trim().toUpperCase();
                    }).get();
                    const duplicates = values.filter((item, index) => item === value.toUpperCase() && values
                        .indexOf(item) !== index);
                    if (duplicates.length > 0) {
                        $input.addClass('is-invalid');
                        $input.siblings('.invalid-feedback').remove();
                        $input.after(
                            `<div class="invalid-feedback">${field} is duplicated in this form.</div>`);
                    } else {
                        $input.removeClass('is-invalid');
                        $input.siblings('.invalid-feedback').remove();
                    }
                } else {
                    $input.removeClass('is-invalid');
                    $input.siblings('.invalid-feedback').remove();
                }
            });

            // Client-side validation for crr_no duplicates
            $(document).on('input', 'input[name*="crr_no"]', function() {
                const $input = $(this);
                const value = $input.val().trim();
                const field = 'CRR No.';
                console.log(`Checking ${field}:`, value);
                if (value) {
                    const values = $('input[name*="crr_no"]').map(function() {
                        return $(this).val().trim().toUpperCase();
                    }).get();
                    const duplicates = values.filter((item, index) => item === value.toUpperCase() && values
                        .indexOf(item) !== index);
                    if (duplicates.length > 0) {
                        $input.addClass('is-invalid');
                        $input.siblings('.invalid-feedback').remove();
                        $input.after(
                            `<div class="invalid-feedback">${field} is duplicated in this form.</div>`);
                    } else {
                        $input.removeClass('is-invalid');
                        $input.siblings('.invalid-feedback').remove();
                    }
                } else {
                    $input.removeClass('is-invalid');
                    $input.siblings('.invalid-feedback').remove();
                }
            });

            // Initialize remove buttons
            updateRemoveButtons();
        });
    </script>

    <script>
        function handleChange(select) {
            var selectedPlantId = select.value;
            console.log("selectedValue", selectedPlantId);

            var url = '{{ route('getplantclients', [':selectedPlantId']) }}';
            url = url.replace(':selectedPlantId', selectedPlantId);

            $.ajax({
                url: url,
                type: 'GET',
                success: function(response) {
                    console.log(response);

                    if (response.status === 'success') {
                        const clients = response.clients;
                        const manufacturers = response.manufacturers;

                        $('select[name="client_id"]').empty().append(
                            '<option value="">--Select Client Name--</option>');
                        clients.forEach(client => {
                            $('select[name="client_id"]').append('<option value="' + client.client_id +
                                '">' + client.client_name + '</option>');
                        });


                    } else {
                        alert('No clients found for the selected plant.');
                    }
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }
    </script>
@endsection
